<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for browseMessageFromMQResponseBase64Encoded StructType
 * Meta information extracted from the WSDL
 * - documentation: Response message from MQ
 * @subpackage Structs
 */
class BrowseMessageFromMQResponseBase64Encoded extends AbstractStructBase
{
    /**
     * The mqMessage
     * Meta information extracted from the WSDL
     * - documentation: The MQ message as a UTF-8 string, transpher-encoded as Base64. Consumers of this service are expected to first decode the Base64 data, then decode the resulting bytes into an UTF-8 String.
     * - minOccurs: 0
     * @var string
     */
    public $mqMessage;
    /**
     * The evpServiceFault
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\EvpServiceFault
     */
    public $evpServiceFault;
    /**
     * The mqErrorCode
     * Meta information extracted from the WSDL
     * - documentation: 2033 MQ-empty
     * - minOccurs: 0
     * @var int
     */
    public $mqErrorCode;
    /**
     * Constructor method for browseMessageFromMQResponseBase64Encoded
     * @uses BrowseMessageFromMQResponseBase64Encoded::setMqMessage()
     * @uses BrowseMessageFromMQResponseBase64Encoded::setEvpServiceFault()
     * @uses BrowseMessageFromMQResponseBase64Encoded::setMqErrorCode()
     * @param string $mqMessage
     * @param \StructType\EvpServiceFault $evpServiceFault
     * @param int $mqErrorCode
     */
    public function __construct($mqMessage = null, \StructType\EvpServiceFault $evpServiceFault = null, $mqErrorCode = null)
    {
        $this
            ->setMqMessage($mqMessage)
            ->setEvpServiceFault($evpServiceFault)
            ->setMqErrorCode($mqErrorCode);
    }
    /**
     * Get mqMessage value
     * @return string|null
     */
    public function getMqMessage()
    {
        return $this->mqMessage;
    }
    /**
     * Set mqMessage value
     * @param string $mqMessage
     * @return \StructType\BrowseMessageFromMQResponseBase64Encoded
     */
    public function setMqMessage($mqMessage = null)
    {
        // validation for constraint: string
        if (!is_null($mqMessage) && !is_string($mqMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mqMessage, true), gettype($mqMessage)), __LINE__);
        }
        $this->mqMessage = $mqMessage;
        return $this;
    }
    /**
     * Get evpServiceFault value
     * @return \StructType\EvpServiceFault|null
     */
    public function getEvpServiceFault()
    {
        return $this->evpServiceFault;
    }
    /**
     * Set evpServiceFault value
     * @param \StructType\EvpServiceFault $evpServiceFault
     * @return \StructType\BrowseMessageFromMQResponseBase64Encoded
     */
    public function setEvpServiceFault(\StructType\EvpServiceFault $evpServiceFault = null)
    {
        $this->evpServiceFault = $evpServiceFault;
        return $this;
    }
    /**
     * Get mqErrorCode value
     * @return int|null
     */
    public function getMqErrorCode()
    {
        return $this->mqErrorCode;
    }
    /**
     * Set mqErrorCode value
     * @param int $mqErrorCode
     * @return \StructType\BrowseMessageFromMQResponseBase64Encoded
     */
    public function setMqErrorCode($mqErrorCode = null)
    {
        // validation for constraint: int
        if (!is_null($mqErrorCode) && !(is_int($mqErrorCode) || ctype_digit($mqErrorCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($mqErrorCode, true), gettype($mqErrorCode)), __LINE__);
        }
        $this->mqErrorCode = $mqErrorCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BrowseMessageFromMQResponseBase64Encoded
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
