<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for bonusMalusSystemType StructType
 * @subpackage Structs
 */
class BonusMalusSystemType extends AbstractStructBase
{
    /**
     * The bonusMalusVorversicherung
     * Meta information extracted from the WSDL
     * - documentation: Auswahlliste (statt ja/nein) ab 02/2018
     * @var string
     */
    public $bonusMalusVorversicherung;
    /**
     * The versicherungsgesellschaft
     * Meta information extracted from the WSDL
     * - documentation: OMDS VERS_UNTERNEHMEN VUNr - https://www.vvo.at/vvo/vvo.nsf/sysPages/x751F64EEDB80A61BC1257C3D007EACA2/$file/Handbuch_OMDS_2_x_2012-09-10.pdf - Kapitel 5
     * - base: xs:string
     * - minOccurs: 0
     * - pattern: [0-9]{3}
     * @var string
     */
    public $versicherungsgesellschaft;
    /**
     * The polizzennummer
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 15
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $polizzennummer;
    /**
     * The offeneSchaeden
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\OffeneSchaedenType
     */
    public $offeneSchaeden;
    /**
     * Constructor method for bonusMalusSystemType
     * @uses BonusMalusSystemType::setBonusMalusVorversicherung()
     * @uses BonusMalusSystemType::setVersicherungsgesellschaft()
     * @uses BonusMalusSystemType::setPolizzennummer()
     * @uses BonusMalusSystemType::setOffeneSchaeden()
     * @param string $bonusMalusVorversicherung
     * @param string $versicherungsgesellschaft
     * @param string $polizzennummer
     * @param \StructType\OffeneSchaedenType $offeneSchaeden
     */
    public function __construct($bonusMalusVorversicherung = null, $versicherungsgesellschaft = null, $polizzennummer = null, \StructType\OffeneSchaedenType $offeneSchaeden = null)
    {
        $this
            ->setBonusMalusVorversicherung($bonusMalusVorversicherung)
            ->setVersicherungsgesellschaft($versicherungsgesellschaft)
            ->setPolizzennummer($polizzennummer)
            ->setOffeneSchaeden($offeneSchaeden);
    }
    /**
     * Get bonusMalusVorversicherung value
     * @return string|null
     */
    public function getBonusMalusVorversicherung()
    {
        return $this->bonusMalusVorversicherung;
    }
    /**
     * Set bonusMalusVorversicherung value
     * @uses \EnumType\BonusMalusVorversicherungType::valueIsValid()
     * @uses \EnumType\BonusMalusVorversicherungType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $bonusMalusVorversicherung
     * @return \StructType\BonusMalusSystemType
     */
    public function setBonusMalusVorversicherung($bonusMalusVorversicherung = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\BonusMalusVorversicherungType::valueIsValid($bonusMalusVorversicherung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\BonusMalusVorversicherungType', is_array($bonusMalusVorversicherung) ? implode(', ', $bonusMalusVorversicherung) : var_export($bonusMalusVorversicherung, true), implode(', ', \EnumType\BonusMalusVorversicherungType::getValidValues())), __LINE__);
        }
        $this->bonusMalusVorversicherung = $bonusMalusVorversicherung;
        return $this;
    }
    /**
     * Get versicherungsgesellschaft value
     * @return string|null
     */
    public function getVersicherungsgesellschaft()
    {
        return $this->versicherungsgesellschaft;
    }
    /**
     * Set versicherungsgesellschaft value
     * @param string $versicherungsgesellschaft
     * @return \StructType\BonusMalusSystemType
     */
    public function setVersicherungsgesellschaft($versicherungsgesellschaft = null)
    {
        // validation for constraint: string
        if (!is_null($versicherungsgesellschaft) && !is_string($versicherungsgesellschaft)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($versicherungsgesellschaft, true), gettype($versicherungsgesellschaft)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{3})
        if (!is_null($versicherungsgesellschaft) && !preg_match('/[0-9]{3}/', $versicherungsgesellschaft)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{3}', var_export($versicherungsgesellschaft, true)), __LINE__);
        }
        $this->versicherungsgesellschaft = $versicherungsgesellschaft;
        return $this;
    }
    /**
     * Get polizzennummer value
     * @return string|null
     */
    public function getPolizzennummer()
    {
        return $this->polizzennummer;
    }
    /**
     * Set polizzennummer value
     * @param string $polizzennummer
     * @return \StructType\BonusMalusSystemType
     */
    public function setPolizzennummer($polizzennummer = null)
    {
        // validation for constraint: string
        if (!is_null($polizzennummer) && !is_string($polizzennummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($polizzennummer, true), gettype($polizzennummer)), __LINE__);
        }
        // validation for constraint: maxLength(15)
        if (!is_null($polizzennummer) && mb_strlen($polizzennummer) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 15', mb_strlen($polizzennummer)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($polizzennummer) && mb_strlen($polizzennummer) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($polizzennummer)), __LINE__);
        }
        $this->polizzennummer = $polizzennummer;
        return $this;
    }
    /**
     * Get offeneSchaeden value
     * @return \StructType\OffeneSchaedenType|null
     */
    public function getOffeneSchaeden()
    {
        return $this->offeneSchaeden;
    }
    /**
     * Set offeneSchaeden value
     * @param \StructType\OffeneSchaedenType $offeneSchaeden
     * @return \StructType\BonusMalusSystemType
     */
    public function setOffeneSchaeden(\StructType\OffeneSchaedenType $offeneSchaeden = null)
    {
        $this->offeneSchaeden = $offeneSchaeden;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BonusMalusSystemType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
