<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BehandlerVZ StructType
 * Meta information extracted from the WSDL
 * - documentation: Verzeichnis aller Behandler in Österreich
 * @subpackage Structs
 */
class BehandlerVZ extends AbstractStructBase
{
    /**
     * The practionerKey
     * Meta information extracted from the WSDL
     * - documentation: eindeutiger Behandlerkey
     * - minOccurs: 0
     * @var string
     */
    public $practionerKey;
    /**
     * The practionerDescription
     * Meta information extracted from the WSDL
     * - documentation: Behandlerbezeichnung/-name
     * - minOccurs: 0
     * @var string
     */
    public $practionerDescription;
    /**
     * The treatmentType
     * Meta information extracted from the WSDL
     * - documentation: Art des Behandlers
     * - minOccurs: 0
     * @var \StructType\BehandlerArtKP
     */
    public $treatmentType;
    /**
     * The practionerPostCode
     * Meta information extracted from the WSDL
     * - documentation: Postleitzahl des Behandlers
     * - minOccurs: 0
     * @var string
     */
    public $practionerPostCode;
    /**
     * The practionerPlace
     * Meta information extracted from the WSDL
     * - documentation: Ort des Behandlers
     * - minOccurs: 0
     * @var string
     */
    public $practionerPlace;
    /**
     * The practionerAdress
     * Meta information extracted from the WSDL
     * - documentation: Anschrift Behandlers
     * - minOccurs: 0
     * @var string
     */
    public $practionerAdress;
    /**
     * The expertise
     * Meta information extracted from the WSDL
     * - documentation: Fachgebiet
     * - minOccurs: 0
     * @var string
     */
    public $expertise;
    /**
     * Constructor method for BehandlerVZ
     * @uses BehandlerVZ::setPractionerKey()
     * @uses BehandlerVZ::setPractionerDescription()
     * @uses BehandlerVZ::setTreatmentType()
     * @uses BehandlerVZ::setPractionerPostCode()
     * @uses BehandlerVZ::setPractionerPlace()
     * @uses BehandlerVZ::setPractionerAdress()
     * @uses BehandlerVZ::setExpertise()
     * @param string $practionerKey
     * @param string $practionerDescription
     * @param \StructType\BehandlerArtKP $treatmentType
     * @param string $practionerPostCode
     * @param string $practionerPlace
     * @param string $practionerAdress
     * @param string $expertise
     */
    public function __construct($practionerKey = null, $practionerDescription = null, \StructType\BehandlerArtKP $treatmentType = null, $practionerPostCode = null, $practionerPlace = null, $practionerAdress = null, $expertise = null)
    {
        $this
            ->setPractionerKey($practionerKey)
            ->setPractionerDescription($practionerDescription)
            ->setTreatmentType($treatmentType)
            ->setPractionerPostCode($practionerPostCode)
            ->setPractionerPlace($practionerPlace)
            ->setPractionerAdress($practionerAdress)
            ->setExpertise($expertise);
    }
    /**
     * Get practionerKey value
     * @return string|null
     */
    public function getPractionerKey()
    {
        return $this->practionerKey;
    }
    /**
     * Set practionerKey value
     * @param string $practionerKey
     * @return \StructType\BehandlerVZ
     */
    public function setPractionerKey($practionerKey = null)
    {
        // validation for constraint: string
        if (!is_null($practionerKey) && !is_string($practionerKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($practionerKey, true), gettype($practionerKey)), __LINE__);
        }
        $this->practionerKey = $practionerKey;
        return $this;
    }
    /**
     * Get practionerDescription value
     * @return string|null
     */
    public function getPractionerDescription()
    {
        return $this->practionerDescription;
    }
    /**
     * Set practionerDescription value
     * @param string $practionerDescription
     * @return \StructType\BehandlerVZ
     */
    public function setPractionerDescription($practionerDescription = null)
    {
        // validation for constraint: string
        if (!is_null($practionerDescription) && !is_string($practionerDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($practionerDescription, true), gettype($practionerDescription)), __LINE__);
        }
        $this->practionerDescription = $practionerDescription;
        return $this;
    }
    /**
     * Get treatmentType value
     * @return \StructType\BehandlerArtKP|null
     */
    public function getTreatmentType()
    {
        return $this->treatmentType;
    }
    /**
     * Set treatmentType value
     * @param \StructType\BehandlerArtKP $treatmentType
     * @return \StructType\BehandlerVZ
     */
    public function setTreatmentType(\StructType\BehandlerArtKP $treatmentType = null)
    {
        $this->treatmentType = $treatmentType;
        return $this;
    }
    /**
     * Get practionerPostCode value
     * @return string|null
     */
    public function getPractionerPostCode()
    {
        return $this->practionerPostCode;
    }
    /**
     * Set practionerPostCode value
     * @param string $practionerPostCode
     * @return \StructType\BehandlerVZ
     */
    public function setPractionerPostCode($practionerPostCode = null)
    {
        // validation for constraint: string
        if (!is_null($practionerPostCode) && !is_string($practionerPostCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($practionerPostCode, true), gettype($practionerPostCode)), __LINE__);
        }
        $this->practionerPostCode = $practionerPostCode;
        return $this;
    }
    /**
     * Get practionerPlace value
     * @return string|null
     */
    public function getPractionerPlace()
    {
        return $this->practionerPlace;
    }
    /**
     * Set practionerPlace value
     * @param string $practionerPlace
     * @return \StructType\BehandlerVZ
     */
    public function setPractionerPlace($practionerPlace = null)
    {
        // validation for constraint: string
        if (!is_null($practionerPlace) && !is_string($practionerPlace)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($practionerPlace, true), gettype($practionerPlace)), __LINE__);
        }
        $this->practionerPlace = $practionerPlace;
        return $this;
    }
    /**
     * Get practionerAdress value
     * @return string|null
     */
    public function getPractionerAdress()
    {
        return $this->practionerAdress;
    }
    /**
     * Set practionerAdress value
     * @param string $practionerAdress
     * @return \StructType\BehandlerVZ
     */
    public function setPractionerAdress($practionerAdress = null)
    {
        // validation for constraint: string
        if (!is_null($practionerAdress) && !is_string($practionerAdress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($practionerAdress, true), gettype($practionerAdress)), __LINE__);
        }
        $this->practionerAdress = $practionerAdress;
        return $this;
    }
    /**
     * Get expertise value
     * @return string|null
     */
    public function getExpertise()
    {
        return $this->expertise;
    }
    /**
     * Set expertise value
     * @param string $expertise
     * @return \StructType\BehandlerVZ
     */
    public function setExpertise($expertise = null)
    {
        // validation for constraint: string
        if (!is_null($expertise) && !is_string($expertise)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expertise, true), gettype($expertise)), __LINE__);
        }
        $this->expertise = $expertise;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BehandlerVZ
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
