<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BankAccountOwner StructType
 * @subpackage Structs
 */
class BankAccountOwner extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $name;
    /**
     * The vorname
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $vorname;
    /**
     * The anrede
     * Meta information extracted from the WSDL
     * - documentation: Anrede des Kontoinhabers (Wird hier 3 angegeben (Firma) wird nur das Feld name für den Firmennamen herangezogen)
     * - minOccurs: 0
     * @var string
     */
    public $anrede;
    /**
     * Constructor method for BankAccountOwner
     * @uses BankAccountOwner::setName()
     * @uses BankAccountOwner::setVorname()
     * @uses BankAccountOwner::setAnrede()
     * @param string $name
     * @param string $vorname
     * @param string $anrede
     */
    public function __construct($name = null, $vorname = null, $anrede = null)
    {
        $this
            ->setName($name)
            ->setVorname($vorname)
            ->setAnrede($anrede);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\BankAccountOwner
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get vorname value
     * @return string
     */
    public function getVorname()
    {
        return $this->vorname;
    }
    /**
     * Set vorname value
     * @param string $vorname
     * @return \StructType\BankAccountOwner
     */
    public function setVorname($vorname = null)
    {
        // validation for constraint: string
        if (!is_null($vorname) && !is_string($vorname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vorname, true), gettype($vorname)), __LINE__);
        }
        $this->vorname = $vorname;
        return $this;
    }
    /**
     * Get anrede value
     * @return string|null
     */
    public function getAnrede()
    {
        return $this->anrede;
    }
    /**
     * Set anrede value
     * @uses \EnumType\AnredeSM::valueIsValid()
     * @uses \EnumType\AnredeSM::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $anrede
     * @return \StructType\BankAccountOwner
     */
    public function setAnrede($anrede = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AnredeSM::valueIsValid($anrede)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AnredeSM', is_array($anrede) ? implode(', ', $anrede) : var_export($anrede, true), implode(', ', \EnumType\AnredeSM::getValidValues())), __LINE__);
        }
        $this->anrede = $anrede;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BankAccountOwner
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
