<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for addCustomerToBusinessCaseRequest StructType
 * @subpackage Structs
 */
class AddCustomerToBusinessCaseRequest extends AbstractStructBase
{
    /**
     * The login
     * @var \StructType\Login
     */
    public $login;
    /**
     * The customer
     * @var \StructType\Customer
     */
    public $customer;
    /**
     * The businessCaseNumber
     * Meta information extracted from the WSDL
     * - documentation: ID des Geschäftsfalles in der eVP
     * - minOccurs: 0
     * @var int
     */
    public $businessCaseNumber;
    /**
     * Constructor method for addCustomerToBusinessCaseRequest
     * @uses AddCustomerToBusinessCaseRequest::setLogin()
     * @uses AddCustomerToBusinessCaseRequest::setCustomer()
     * @uses AddCustomerToBusinessCaseRequest::setBusinessCaseNumber()
     * @param \StructType\Login $login
     * @param \StructType\Customer $customer
     * @param int $businessCaseNumber
     */
    public function __construct(\StructType\Login $login = null, \StructType\Customer $customer = null, $businessCaseNumber = null)
    {
        $this
            ->setLogin($login)
            ->setCustomer($customer)
            ->setBusinessCaseNumber($businessCaseNumber);
    }
    /**
     * Get login value
     * @return \StructType\Login|null
     */
    public function getLogin()
    {
        return $this->login;
    }
    /**
     * Set login value
     * @param \StructType\Login $login
     * @return \StructType\AddCustomerToBusinessCaseRequest
     */
    public function setLogin(\StructType\Login $login = null)
    {
        $this->login = $login;
        return $this;
    }
    /**
     * Get customer value
     * @return \StructType\Customer|null
     */
    public function getCustomer()
    {
        return $this->customer;
    }
    /**
     * Set customer value
     * @param \StructType\Customer $customer
     * @return \StructType\AddCustomerToBusinessCaseRequest
     */
    public function setCustomer(\StructType\Customer $customer = null)
    {
        $this->customer = $customer;
        return $this;
    }
    /**
     * Get businessCaseNumber value
     * @return int|null
     */
    public function getBusinessCaseNumber()
    {
        return $this->businessCaseNumber;
    }
    /**
     * Set businessCaseNumber value
     * @param int $businessCaseNumber
     * @return \StructType\AddCustomerToBusinessCaseRequest
     */
    public function setBusinessCaseNumber($businessCaseNumber = null)
    {
        // validation for constraint: int
        if (!is_null($businessCaseNumber) && !(is_int($businessCaseNumber) || ctype_digit($businessCaseNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($businessCaseNumber, true), gettype($businessCaseNumber)), __LINE__);
        }
        $this->businessCaseNumber = $businessCaseNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AddCustomerToBusinessCaseRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
