<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for accidentInsurance StructType
 * @subpackage Structs
 */
class AccidentInsurance extends AbstractStructBase
{
    /**
     * The general
     * @var \StructType\CommonData
     */
    public $general;
    /**
     * The injuredPerson
     * @var \StructType\ClaimentPerson
     */
    public $injuredPerson;
    /**
     * The profession
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $profession;
    /**
     * The besideInsurance
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $besideInsurance;
    /**
     * The typeOfAccident
     * @var string
     */
    public $typeOfAccident;
    /**
     * The injuredBodyPart
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $injuredBodyPart;
    /**
     * The handlerHospital
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $handlerHospital;
    /**
     * Constructor method for accidentInsurance
     * @uses AccidentInsurance::setGeneral()
     * @uses AccidentInsurance::setInjuredPerson()
     * @uses AccidentInsurance::setProfession()
     * @uses AccidentInsurance::setBesideInsurance()
     * @uses AccidentInsurance::setTypeOfAccident()
     * @uses AccidentInsurance::setInjuredBodyPart()
     * @uses AccidentInsurance::setHandlerHospital()
     * @param \StructType\CommonData $general
     * @param \StructType\ClaimentPerson $injuredPerson
     * @param string $profession
     * @param bool $besideInsurance
     * @param string $typeOfAccident
     * @param string $injuredBodyPart
     * @param string $handlerHospital
     */
    public function __construct(\StructType\CommonData $general = null, \StructType\ClaimentPerson $injuredPerson = null, $profession = null, $besideInsurance = null, $typeOfAccident = null, $injuredBodyPart = null, $handlerHospital = null)
    {
        $this
            ->setGeneral($general)
            ->setInjuredPerson($injuredPerson)
            ->setProfession($profession)
            ->setBesideInsurance($besideInsurance)
            ->setTypeOfAccident($typeOfAccident)
            ->setInjuredBodyPart($injuredBodyPart)
            ->setHandlerHospital($handlerHospital);
    }
    /**
     * Get general value
     * @return \StructType\CommonData|null
     */
    public function getGeneral()
    {
        return $this->general;
    }
    /**
     * Set general value
     * @param \StructType\CommonData $general
     * @return \StructType\AccidentInsurance
     */
    public function setGeneral(\StructType\CommonData $general = null)
    {
        $this->general = $general;
        return $this;
    }
    /**
     * Get injuredPerson value
     * @return \StructType\ClaimentPerson|null
     */
    public function getInjuredPerson()
    {
        return $this->injuredPerson;
    }
    /**
     * Set injuredPerson value
     * @param \StructType\ClaimentPerson $injuredPerson
     * @return \StructType\AccidentInsurance
     */
    public function setInjuredPerson(\StructType\ClaimentPerson $injuredPerson = null)
    {
        $this->injuredPerson = $injuredPerson;
        return $this;
    }
    /**
     * Get profession value
     * @return string|null
     */
    public function getProfession()
    {
        return $this->profession;
    }
    /**
     * Set profession value
     * @param string $profession
     * @return \StructType\AccidentInsurance
     */
    public function setProfession($profession = null)
    {
        // validation for constraint: string
        if (!is_null($profession) && !is_string($profession)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($profession, true), gettype($profession)), __LINE__);
        }
        $this->profession = $profession;
        return $this;
    }
    /**
     * Get besideInsurance value
     * @return bool|null
     */
    public function getBesideInsurance()
    {
        return $this->besideInsurance;
    }
    /**
     * Set besideInsurance value
     * @param bool $besideInsurance
     * @return \StructType\AccidentInsurance
     */
    public function setBesideInsurance($besideInsurance = null)
    {
        // validation for constraint: boolean
        if (!is_null($besideInsurance) && !is_bool($besideInsurance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($besideInsurance, true), gettype($besideInsurance)), __LINE__);
        }
        $this->besideInsurance = $besideInsurance;
        return $this;
    }
    /**
     * Get typeOfAccident value
     * @return string|null
     */
    public function getTypeOfAccident()
    {
        return $this->typeOfAccident;
    }
    /**
     * Set typeOfAccident value
     * @uses \EnumType\TypeOfAccident::valueIsValid()
     * @uses \EnumType\TypeOfAccident::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $typeOfAccident
     * @return \StructType\AccidentInsurance
     */
    public function setTypeOfAccident($typeOfAccident = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TypeOfAccident::valueIsValid($typeOfAccident)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TypeOfAccident', is_array($typeOfAccident) ? implode(', ', $typeOfAccident) : var_export($typeOfAccident, true), implode(', ', \EnumType\TypeOfAccident::getValidValues())), __LINE__);
        }
        $this->typeOfAccident = $typeOfAccident;
        return $this;
    }
    /**
     * Get injuredBodyPart value
     * @return string|null
     */
    public function getInjuredBodyPart()
    {
        return $this->injuredBodyPart;
    }
    /**
     * Set injuredBodyPart value
     * @uses \EnumType\InjuredBodyPart::valueIsValid()
     * @uses \EnumType\InjuredBodyPart::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $injuredBodyPart
     * @return \StructType\AccidentInsurance
     */
    public function setInjuredBodyPart($injuredBodyPart = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\InjuredBodyPart::valueIsValid($injuredBodyPart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\InjuredBodyPart', is_array($injuredBodyPart) ? implode(', ', $injuredBodyPart) : var_export($injuredBodyPart, true), implode(', ', \EnumType\InjuredBodyPart::getValidValues())), __LINE__);
        }
        $this->injuredBodyPart = $injuredBodyPart;
        return $this;
    }
    /**
     * Get handlerHospital value
     * @return string|null
     */
    public function getHandlerHospital()
    {
        return $this->handlerHospital;
    }
    /**
     * Set handlerHospital value
     * @param string $handlerHospital
     * @return \StructType\AccidentInsurance
     */
    public function setHandlerHospital($handlerHospital = null)
    {
        // validation for constraint: string
        if (!is_null($handlerHospital) && !is_string($handlerHospital)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($handlerHospital, true), gettype($handlerHospital)), __LINE__);
        }
        $this->handlerHospital = $handlerHospital;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AccidentInsurance
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
