<?php

namespace EnumType;

/**
 * This class stands for zustandsbeschreibungType EnumType
 * @subpackage Enumerations
 */
class ZustandsbeschreibungType
{
    /**
     * Constant for value 'Besichtigung durch Betreuer'
     * @return string 'Besichtigung durch Betreuer'
     */
    const ENUM_VALUE_0 = 'Besichtigung durch Betreuer';
    /**
     * Constant for value 'Kaufvertrag eines Markenhändlers mit Beschreibung (Kopie
     * erforderlich)'
     * @return string 'Kaufvertrag eines Markenhändlers mit Beschreibung (Kopie erforderlich)'
     */
    const ENUM_VALUE_1 = 'Kaufvertrag eines Markenhändlers mit Beschreibung (Kopie erforderlich)';
    /**
     * Constant for value 'Besichtigung durch ÖAMTC'
     * @return string 'Besichtigung durch ÖAMTC'
     */
    const ENUM_VALUE_2 = 'Besichtigung durch ÖAMTC';
    /**
     * Constant for value 'Nachbesichtigung'
     * @return string 'Nachbesichtigung'
     */
    const ENUM_VALUE_3 = 'Nachbesichtigung';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::ENUM_VALUE_0
     * @uses self::ENUM_VALUE_1
     * @uses self::ENUM_VALUE_2
     * @uses self::ENUM_VALUE_3
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::ENUM_VALUE_0,
            self::ENUM_VALUE_1,
            self::ENUM_VALUE_2,
            self::ENUM_VALUE_3,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
