<?php

namespace EnumType;

/**
 * This class stands for zahlungsartType EnumType
 * @subpackage Enumerations
 */
class ZahlungsartType
{
    /**
     * Constant for value 'Kontoeinzug'
     * @return string 'Kontoeinzug'
     */
    const ENUM_VALUE_0 = 'Kontoeinzug';
    /**
     * Constant for value 'Zahlungsanweisung'
     * @return string 'Zahlungsanweisung'
     */
    const ENUM_VALUE_1 = 'Zahlungsanweisung';
    /**
     * Constant for value 'Kundenkonto'
     * @return string 'Kundenkonto'
     */
    const ENUM_VALUE_2 = 'Kundenkonto';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::ENUM_VALUE_0
     * @uses self::ENUM_VALUE_1
     * @uses self::ENUM_VALUE_2
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::ENUM_VALUE_0,
            self::ENUM_VALUE_1,
            self::ENUM_VALUE_2,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
