<?php

namespace EnumType;

/**
 * This class stands for vbArtType EnumType
 * @subpackage Enumerations
 */
class VbArtType
{
    /**
     * Constant for value 'keine'
     * @return string 'keine'
     */
    const ENUM_VALUE_0 = 'keine';
    /**
     * Constant for value 'VB ohne vorläufige Deckung'
     * @return string 'VB ohne vorläufige Deckung'
     */
    const ENUM_VALUE_1 = 'VB ohne vorläufige Deckung';
    /**
     * Constant for value 'VB mit vorläufiger Deckung'
     * @return string 'VB mit vorläufiger Deckung'
     */
    const ENUM_VALUE_2 = 'VB mit vorläufiger Deckung';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::ENUM_VALUE_0
     * @uses self::ENUM_VALUE_1
     * @uses self::ENUM_VALUE_2
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::ENUM_VALUE_0,
            self::ENUM_VALUE_1,
            self::ENUM_VALUE_2,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
