<?php

namespace EnumType;

/**
 * This class stands for varianteType EnumType
 * @subpackage Enumerations
 */
class VarianteType
{
    /**
     * Constant for value 'Premiumschutz'
     * @return string 'Premiumschutz'
     */
    const ENUM_VALUE_0 = 'Premiumschutz';
    /**
     * Constant for value 'Classicschutz'
     * @return string 'Classicschutz'
     */
    const ENUM_VALUE_1 = 'Classicschutz';
    /**
     * Constant for value 'Basisschutz'
     * @return string 'Basisschutz'
     */
    const ENUM_VALUE_2 = 'Basisschutz';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::ENUM_VALUE_0
     * @uses self::ENUM_VALUE_1
     * @uses self::ENUM_VALUE_2
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::ENUM_VALUE_0,
            self::ENUM_VALUE_1,
            self::ENUM_VALUE_2,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
