<?php

namespace EnumType;

/**
 * This class stands for typeOfAccident EnumType
 * @subpackage Enumerations
 */
class TypeOfAccident
{
    /**
     * Constant for value 'Arbeitsunfall'
     * @return string 'Arbeitsunfall'
     */
    const ENUM_VALUE_0 = 'Arbeitsunfall';
    /**
     * Constant for value 'in der Freizeit/Sonstige'
     * @return string 'in der Freizeit/Sonstige'
     */
    const ENUM_VALUE_1 = 'in der Freizeit/Sonstige';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::ENUM_VALUE_0
     * @uses self::ENUM_VALUE_1
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::ENUM_VALUE_0,
            self::ENUM_VALUE_1,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
