<?php

namespace EnumType;

/**
 * This class stands for serviceType EnumType
 * @subpackage Enumerations
 */
class ServiceType
{
    /**
     * Constant for value '0'
     * Meta information extracted from the WSDL
     * - id: greencard
     * @return string '0'
     */
    const ENUM_VALUE_0 = '0';
    /**
     * Constant for value '1'
     * Meta information extracted from the WSDL
     * - id: servicecard
     * @return string '1'
     */
    const ENUM_VALUE_1 = '1';
    /**
     * Constant for value '2'
     * Meta information extracted from the WSDL
     * - id: policyforwarding
     * @return string '2'
     */
    const ENUM_VALUE_2 = '2';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::ENUM_VALUE_0
     * @uses self::ENUM_VALUE_1
     * @uses self::ENUM_VALUE_2
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::ENUM_VALUE_0,
            self::ENUM_VALUE_1,
            self::ENUM_VALUE_2,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
