<?php

namespace EnumType;

/**
 * This class stands for schadenersatzbeitragType EnumType
 * @subpackage Enumerations
 */
class SchadenersatzbeitragType
{
    /**
     * Constant for value 'Nein'
     * @return string 'Nein'
     */
    const ENUM_VALUE_0 = 'Nein';
    /**
     * Constant for value '250,00 EUR/10% Nachlass'
     * @return string '250,00 EUR/10% Nachlass'
     */
    const ENUM_VALUE_1 = '250,00 EUR/10% Nachlass';
    /**
     * Constant for value '350,00 EUR'
     * @return string '350,00 EUR'
     */
    const ENUM_VALUE_2 = '350,00 EUR';
    /**
     * Constant for value '400,00 EUR/20% Nachlass'
     * @return string '400,00 EUR/20% Nachlass'
     */
    const ENUM_VALUE_3 = '400,00 EUR/20% Nachlass';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::ENUM_VALUE_0
     * @uses self::ENUM_VALUE_1
     * @uses self::ENUM_VALUE_2
     * @uses self::ENUM_VALUE_3
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::ENUM_VALUE_0,
            self::ENUM_VALUE_1,
            self::ENUM_VALUE_2,
            self::ENUM_VALUE_3,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
