<?php

namespace EnumType;

/**
 * This class stands for polizzenversandType EnumType
 * @subpackage Enumerations
 */
class PolizzenversandType
{
    /**
     * Constant for value 'MAK2'
     * Meta information extracted from the WSDL
     * - documentation: 2fach Makler: Ist nur bei Postversand möglich. Makler erhält Original und Kopie
     * @return string 'MAK2'
     */
    const ENUM_VALUE_0 = 'MAK2';
    /**
     * Constant for value 'VN1'
     * Meta information extracted from the WSDL
     * - documentation: 1fach Versicherungsnehmer: Kunde erhält Original
     * @return string 'VN1'
     */
    const ENUM_VALUE_1 = 'VN1';
    /**
     * Constant for value 'MAKVN'
     * Meta information extracted from the WSDL
     * - documentation: 1fach Makler und 1fach Versicherungsnehmer: Kunde erhält Original und Makler die Kopie
     * @return string 'MAKVN'
     */
    const ENUM_VALUE_2 = 'MAKVN';
    /**
     * Constant for value 'MAK1'
     * Meta information extracted from the WSDL
     * - documentation: 1fach Makler: Makler erhält Original
     * @return string 'MAK1'
     */
    const ENUM_VALUE_3 = 'MAK1';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::ENUM_VALUE_0
     * @uses self::ENUM_VALUE_1
     * @uses self::ENUM_VALUE_2
     * @uses self::ENUM_VALUE_3
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::ENUM_VALUE_0,
            self::ENUM_VALUE_1,
            self::ENUM_VALUE_2,
            self::ENUM_VALUE_3,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
