<?php

namespace EnumType;

/**
 * This class stands for kommunikationsTypType EnumType
 * @subpackage Enumerations
 */
class KommunikationsTypType
{
    /**
     * Constant for value 'Ansprechpartner'
     * @return string 'Ansprechpartner'
     */
    const ENUM_VALUE_0 = 'Ansprechpartner';
    /**
     * Constant for value 'E-Mail'
     * @return string 'E-Mail'
     */
    const ENUM_VALUE_1 = 'E-Mail';
    /**
     * Constant for value 'Faxanschluss'
     * @return string 'Faxanschluss'
     */
    const ENUM_VALUE_2 = 'Faxanschluss';
    /**
     * Constant for value 'Mobiltelefon'
     * @return string 'Mobiltelefon'
     */
    const ENUM_VALUE_3 = 'Mobiltelefon';
    /**
     * Constant for value 'Telefon (berufl.)'
     * @return string 'Telefon (berufl.)'
     */
    const ENUM_VALUE_4 = 'Telefon (berufl.)';
    /**
     * Constant for value 'Telefon (privat)'
     * @return string 'Telefon (privat)'
     */
    const ENUM_VALUE_5 = 'Telefon (privat)';
    /**
     * Constant for value 'www-Homepage'
     * @return string 'www-Homepage'
     */
    const ENUM_VALUE_6 = 'www-Homepage';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::ENUM_VALUE_0
     * @uses self::ENUM_VALUE_1
     * @uses self::ENUM_VALUE_2
     * @uses self::ENUM_VALUE_3
     * @uses self::ENUM_VALUE_4
     * @uses self::ENUM_VALUE_5
     * @uses self::ENUM_VALUE_6
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::ENUM_VALUE_0,
            self::ENUM_VALUE_1,
            self::ENUM_VALUE_2,
            self::ENUM_VALUE_3,
            self::ENUM_VALUE_4,
            self::ENUM_VALUE_5,
            self::ENUM_VALUE_6,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
