<?php

namespace EnumType;

/**
 * This class stands for kaskoVersicherungsartType EnumType
 * @subpackage Enumerations
 */
class KaskoVersicherungsartType
{
    /**
     * Constant for value 'Vollkasko'
     * @return string 'Vollkasko'
     */
    const ENUM_VALUE_0 = 'Vollkasko';
    /**
     * Constant for value 'Vollkasko mit gen. SB'
     * @return string 'Vollkasko mit gen. SB'
     */
    const ENUM_VALUE_1 = 'Vollkasko mit gen. SB';
    /**
     * Constant for value 'Teilkasko'
     * @return string 'Teilkasko'
     */
    const ENUM_VALUE_2 = 'Teilkasko';
    /**
     * Constant for value 'Teilkasko mit gen. SB'
     * @return string 'Teilkasko mit gen. SB'
     */
    const ENUM_VALUE_3 = 'Teilkasko mit gen. SB';
    /**
     * Constant for value 'Parkschadenkasko'
     * @return string 'Parkschadenkasko'
     */
    const ENUM_VALUE_4 = 'Parkschadenkasko';
    /**
     * Constant for value 'Parkschadenkasko mit gen. SB'
     * @return string 'Parkschadenkasko mit gen. SB'
     */
    const ENUM_VALUE_5 = 'Parkschadenkasko mit gen. SB';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::ENUM_VALUE_0
     * @uses self::ENUM_VALUE_1
     * @uses self::ENUM_VALUE_2
     * @uses self::ENUM_VALUE_3
     * @uses self::ENUM_VALUE_4
     * @uses self::ENUM_VALUE_5
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::ENUM_VALUE_0,
            self::ENUM_VALUE_1,
            self::ENUM_VALUE_2,
            self::ENUM_VALUE_3,
            self::ENUM_VALUE_4,
            self::ENUM_VALUE_5,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
