<?php

namespace EnumType;

/**
 * This class stands for juniorSeniorType EnumType
 * @subpackage Enumerations
 */
class JuniorSeniorType
{
    /**
     * Constant for value 'Jun'
     * @return string 'Jun'
     */
    const ENUM_VALUE_0 = 'Jun';
    /**
     * Constant for value 'Sen'
     * @return string 'Sen'
     */
    const ENUM_VALUE_1 = 'Sen';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::ENUM_VALUE_0
     * @uses self::ENUM_VALUE_1
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::ENUM_VALUE_0,
            self::ENUM_VALUE_1,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
