<?php

namespace EnumType;

/**
 * This class stands for benutzerType EnumType
 * @subpackage Enumerations
 */
class BenutzerType
{
    /**
     * Constant for value 'keine'
     * @return string 'keine'
     */
    const ENUM_VALUE_0 = 'keine';
    /**
     * Constant for value 'Ehepartner/Lebensgefährte'
     * @return string 'Ehepartner/Lebensgefährte'
     */
    const ENUM_VALUE_1 = 'Ehepartner/Lebensgefährte';
    /**
     * Constant for value 'Ehepartner/Lebensgefährte/Kinder'
     * @return string 'Ehepartner/Lebensgefährte/Kinder'
     */
    const ENUM_VALUE_2 = 'Ehepartner/Lebensgefährte/Kinder';
    /**
     * Constant for value 'andere Personen'
     * @return string 'andere Personen'
     */
    const ENUM_VALUE_3 = 'andere Personen';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::ENUM_VALUE_0
     * @uses self::ENUM_VALUE_1
     * @uses self::ENUM_VALUE_2
     * @uses self::ENUM_VALUE_3
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::ENUM_VALUE_0,
            self::ENUM_VALUE_1,
            self::ENUM_VALUE_2,
            self::ENUM_VALUE_3,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
