<?php

namespace EnumType;

/**
 * This class stands for bauartType EnumType
 * @subpackage Enumerations
 */
class BauartType
{
    /**
     * Constant for value 'Cabriolet'
     * @return string 'Cabriolet'
     */
    const ENUM_VALUE_0 = 'Cabriolet';
    /**
     * Constant for value 'Coupe'
     * @return string 'Coupe'
     */
    const ENUM_VALUE_1 = 'Coupe';
    /**
     * Constant for value 'Limousine'
     * @return string 'Limousine'
     */
    const ENUM_VALUE_2 = 'Limousine';
    /**
     * Constant for value 'Roadster'
     * @return string 'Roadster'
     */
    const ENUM_VALUE_3 = 'Roadster';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::ENUM_VALUE_0
     * @uses self::ENUM_VALUE_1
     * @uses self::ENUM_VALUE_2
     * @uses self::ENUM_VALUE_3
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::ENUM_VALUE_0,
            self::ENUM_VALUE_1,
            self::ENUM_VALUE_2,
            self::ENUM_VALUE_3,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
