<?php

namespace EnumType;

/**
 * This class stands for banklandType EnumType
 * @subpackage Enumerations
 */
class BanklandType
{
    /**
     * Constant for value 'Österreich'
     * @return string 'Österreich'
     */
    const ENUM_VALUE_0 = 'Österreich';
    /**
     * Constant for value 'Deutschland'
     * @return string 'Deutschland'
     */
    const ENUM_VALUE_1 = 'Deutschland';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::ENUM_VALUE_0
     * @uses self::ENUM_VALUE_1
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::ENUM_VALUE_0,
            self::ENUM_VALUE_1,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
