<?php

namespace EnumType;

/**
 * This class stands for antriebsartType EnumType
 * @subpackage Enumerations
 */
class AntriebsartType
{
    /**
     * Constant for value 'Benzin ohne Katalysator'
     * @return string 'Benzin ohne Katalysator'
     */
    const ENUM_VALUE_0 = 'Benzin ohne Katalysator';
    /**
     * Constant for value 'Gas'
     * @return string 'Gas'
     */
    const ENUM_VALUE_1 = 'Gas';
    /**
     * Constant for value 'Diesel'
     * @return string 'Diesel'
     */
    const ENUM_VALUE_2 = 'Diesel';
    /**
     * Constant for value 'Benzin mit Katalysator'
     * @return string 'Benzin mit Katalysator'
     */
    const ENUM_VALUE_3 = 'Benzin mit Katalysator';
    /**
     * Constant for value 'Elektroantrieb'
     * @return string 'Elektroantrieb'
     */
    const ENUM_VALUE_4 = 'Elektroantrieb';
    /**
     * Constant for value 'Diesel mit Katalysator'
     * @return string 'Diesel mit Katalysator'
     */
    const ENUM_VALUE_5 = 'Diesel mit Katalysator';
    /**
     * Constant for value 'Kombinierter Betrieb Benzin/Elektro'
     * @return string 'Kombinierter Betrieb Benzin/Elektro'
     */
    const ENUM_VALUE_6 = 'Kombinierter Betrieb Benzin/Elektro';
    /**
     * Constant for value 'Kombinierter Betrieb Diesel/Elektro'
     * @return string 'Kombinierter Betrieb Diesel/Elektro'
     */
    const ENUM_VALUE_7 = 'Kombinierter Betrieb Diesel/Elektro';
    /**
     * Constant for value 'sonstige'
     * @return string 'sonstige'
     */
    const ENUM_VALUE_8 = 'sonstige';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::ENUM_VALUE_0
     * @uses self::ENUM_VALUE_1
     * @uses self::ENUM_VALUE_2
     * @uses self::ENUM_VALUE_3
     * @uses self::ENUM_VALUE_4
     * @uses self::ENUM_VALUE_5
     * @uses self::ENUM_VALUE_6
     * @uses self::ENUM_VALUE_7
     * @uses self::ENUM_VALUE_8
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::ENUM_VALUE_0,
            self::ENUM_VALUE_1,
            self::ENUM_VALUE_2,
            self::ENUM_VALUE_3,
            self::ENUM_VALUE_4,
            self::ENUM_VALUE_5,
            self::ENUM_VALUE_6,
            self::ENUM_VALUE_7,
            self::ENUM_VALUE_8,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
