<?php

namespace EnumType;

/**
 * This class stands for akkubewertungType EnumType
 * @subpackage Enumerations
 */
class AkkubewertungType
{
    /**
     * Constant for value 'Akku mitversichert (im Fahrzeugwert enthalten)'
     * @return string 'Akku mitversichert (im Fahrzeugwert enthalten)'
     */
    const ENUM_VALUE_0 = 'Akku mitversichert (im Fahrzeugwert enthalten)';
    /**
     * Constant for value 'Akku mitversichert (im Fahrzeugwert nicht enthalten)'
     * @return string 'Akku mitversichert (im Fahrzeugwert nicht enthalten)'
     */
    const ENUM_VALUE_1 = 'Akku mitversichert (im Fahrzeugwert nicht enthalten)';
    /**
     * Constant for value 'Akku nicht mitversichert'
     * @return string 'Akku nicht mitversichert'
     */
    const ENUM_VALUE_2 = 'Akku nicht mitversichert';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::ENUM_VALUE_0
     * @uses self::ENUM_VALUE_1
     * @uses self::ENUM_VALUE_2
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::ENUM_VALUE_0,
            self::ENUM_VALUE_1,
            self::ENUM_VALUE_2,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
