<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for zusaetzlicheKfzdatenType StructType
 * @subpackage Structs
 */
class ZusaetzlicheKfzdatenType extends AbstractStructBase
{
    /**
     * The kfzKennzeichen
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 9
     * - minLength: 3
     * @var string
     */
    public $kfzKennzeichen;
    /**
     * The vvdVertrag
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $vvdVertrag;
    /**
     * The fahrgestellnummer
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 30
     * - minLength: 1
     * @var string
     */
    public $fahrgestellnummer;
    /**
     * The erfolgtAnmeldungZeitgleichMitAbmeldung
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $erfolgtAnmeldungZeitgleichMitAbmeldung;
    /**
     * The abmeldedatumWechselkennzeichenFahrzeug
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $abmeldedatumWechselkennzeichenFahrzeug;
    /**
     * The abmeldedatumVorfahrzeug
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $abmeldedatumVorfahrzeug;
    /**
     * The wechselkennzeichen
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\WechselkennzeichenType
     */
    public $wechselkennzeichen;
    /**
     * The fahrzeugzustand
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\FahrzeugzustandType
     */
    public $fahrzeugzustand;
    /**
     * Constructor method for zusaetzlicheKfzdatenType
     * @uses ZusaetzlicheKfzdatenType::setKfzKennzeichen()
     * @uses ZusaetzlicheKfzdatenType::setVvdVertrag()
     * @uses ZusaetzlicheKfzdatenType::setFahrgestellnummer()
     * @uses ZusaetzlicheKfzdatenType::setErfolgtAnmeldungZeitgleichMitAbmeldung()
     * @uses ZusaetzlicheKfzdatenType::setAbmeldedatumWechselkennzeichenFahrzeug()
     * @uses ZusaetzlicheKfzdatenType::setAbmeldedatumVorfahrzeug()
     * @uses ZusaetzlicheKfzdatenType::setWechselkennzeichen()
     * @uses ZusaetzlicheKfzdatenType::setFahrzeugzustand()
     * @param string $kfzKennzeichen
     * @param string $vvdVertrag
     * @param string $fahrgestellnummer
     * @param string $erfolgtAnmeldungZeitgleichMitAbmeldung
     * @param string $abmeldedatumWechselkennzeichenFahrzeug
     * @param string $abmeldedatumVorfahrzeug
     * @param \StructType\WechselkennzeichenType $wechselkennzeichen
     * @param \StructType\FahrzeugzustandType $fahrzeugzustand
     */
    public function __construct($kfzKennzeichen = null, $vvdVertrag = null, $fahrgestellnummer = null, $erfolgtAnmeldungZeitgleichMitAbmeldung = null, $abmeldedatumWechselkennzeichenFahrzeug = null, $abmeldedatumVorfahrzeug = null, \StructType\WechselkennzeichenType $wechselkennzeichen = null, \StructType\FahrzeugzustandType $fahrzeugzustand = null)
    {
        $this
            ->setKfzKennzeichen($kfzKennzeichen)
            ->setVvdVertrag($vvdVertrag)
            ->setFahrgestellnummer($fahrgestellnummer)
            ->setErfolgtAnmeldungZeitgleichMitAbmeldung($erfolgtAnmeldungZeitgleichMitAbmeldung)
            ->setAbmeldedatumWechselkennzeichenFahrzeug($abmeldedatumWechselkennzeichenFahrzeug)
            ->setAbmeldedatumVorfahrzeug($abmeldedatumVorfahrzeug)
            ->setWechselkennzeichen($wechselkennzeichen)
            ->setFahrzeugzustand($fahrzeugzustand);
    }
    /**
     * Get kfzKennzeichen value
     * @return string|null
     */
    public function getKfzKennzeichen()
    {
        return $this->kfzKennzeichen;
    }
    /**
     * Set kfzKennzeichen value
     * @param string $kfzKennzeichen
     * @return \StructType\ZusaetzlicheKfzdatenType
     */
    public function setKfzKennzeichen($kfzKennzeichen = null)
    {
        // validation for constraint: string
        if (!is_null($kfzKennzeichen) && !is_string($kfzKennzeichen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kfzKennzeichen, true), gettype($kfzKennzeichen)), __LINE__);
        }
        // validation for constraint: maxLength(9)
        if (!is_null($kfzKennzeichen) && mb_strlen($kfzKennzeichen) > 9) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 9', mb_strlen($kfzKennzeichen)), __LINE__);
        }
        // validation for constraint: minLength(3)
        if (!is_null($kfzKennzeichen) && mb_strlen($kfzKennzeichen) < 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 3', mb_strlen($kfzKennzeichen)), __LINE__);
        }
        $this->kfzKennzeichen = $kfzKennzeichen;
        return $this;
    }
    /**
     * Get vvdVertrag value
     * @return string|null
     */
    public function getVvdVertrag()
    {
        return $this->vvdVertrag;
    }
    /**
     * Set vvdVertrag value
     * @uses \EnumType\JaNeinType::valueIsValid()
     * @uses \EnumType\JaNeinType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $vvdVertrag
     * @return \StructType\ZusaetzlicheKfzdatenType
     */
    public function setVvdVertrag($vvdVertrag = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JaNeinType::valueIsValid($vvdVertrag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JaNeinType', is_array($vvdVertrag) ? implode(', ', $vvdVertrag) : var_export($vvdVertrag, true), implode(', ', \EnumType\JaNeinType::getValidValues())), __LINE__);
        }
        $this->vvdVertrag = $vvdVertrag;
        return $this;
    }
    /**
     * Get fahrgestellnummer value
     * @return string|null
     */
    public function getFahrgestellnummer()
    {
        return $this->fahrgestellnummer;
    }
    /**
     * Set fahrgestellnummer value
     * @param string $fahrgestellnummer
     * @return \StructType\ZusaetzlicheKfzdatenType
     */
    public function setFahrgestellnummer($fahrgestellnummer = null)
    {
        // validation for constraint: string
        if (!is_null($fahrgestellnummer) && !is_string($fahrgestellnummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fahrgestellnummer, true), gettype($fahrgestellnummer)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($fahrgestellnummer) && mb_strlen($fahrgestellnummer) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($fahrgestellnummer)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($fahrgestellnummer) && mb_strlen($fahrgestellnummer) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($fahrgestellnummer)), __LINE__);
        }
        $this->fahrgestellnummer = $fahrgestellnummer;
        return $this;
    }
    /**
     * Get erfolgtAnmeldungZeitgleichMitAbmeldung value
     * @return string|null
     */
    public function getErfolgtAnmeldungZeitgleichMitAbmeldung()
    {
        return $this->erfolgtAnmeldungZeitgleichMitAbmeldung;
    }
    /**
     * Set erfolgtAnmeldungZeitgleichMitAbmeldung value
     * @uses \EnumType\JaNeinType::valueIsValid()
     * @uses \EnumType\JaNeinType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $erfolgtAnmeldungZeitgleichMitAbmeldung
     * @return \StructType\ZusaetzlicheKfzdatenType
     */
    public function setErfolgtAnmeldungZeitgleichMitAbmeldung($erfolgtAnmeldungZeitgleichMitAbmeldung = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JaNeinType::valueIsValid($erfolgtAnmeldungZeitgleichMitAbmeldung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JaNeinType', is_array($erfolgtAnmeldungZeitgleichMitAbmeldung) ? implode(', ', $erfolgtAnmeldungZeitgleichMitAbmeldung) : var_export($erfolgtAnmeldungZeitgleichMitAbmeldung, true), implode(', ', \EnumType\JaNeinType::getValidValues())), __LINE__);
        }
        $this->erfolgtAnmeldungZeitgleichMitAbmeldung = $erfolgtAnmeldungZeitgleichMitAbmeldung;
        return $this;
    }
    /**
     * Get abmeldedatumWechselkennzeichenFahrzeug value
     * @return string|null
     */
    public function getAbmeldedatumWechselkennzeichenFahrzeug()
    {
        return $this->abmeldedatumWechselkennzeichenFahrzeug;
    }
    /**
     * Set abmeldedatumWechselkennzeichenFahrzeug value
     * @param string $abmeldedatumWechselkennzeichenFahrzeug
     * @return \StructType\ZusaetzlicheKfzdatenType
     */
    public function setAbmeldedatumWechselkennzeichenFahrzeug($abmeldedatumWechselkennzeichenFahrzeug = null)
    {
        // validation for constraint: string
        if (!is_null($abmeldedatumWechselkennzeichenFahrzeug) && !is_string($abmeldedatumWechselkennzeichenFahrzeug)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($abmeldedatumWechselkennzeichenFahrzeug, true), gettype($abmeldedatumWechselkennzeichenFahrzeug)), __LINE__);
        }
        $this->abmeldedatumWechselkennzeichenFahrzeug = $abmeldedatumWechselkennzeichenFahrzeug;
        return $this;
    }
    /**
     * Get abmeldedatumVorfahrzeug value
     * @return string|null
     */
    public function getAbmeldedatumVorfahrzeug()
    {
        return $this->abmeldedatumVorfahrzeug;
    }
    /**
     * Set abmeldedatumVorfahrzeug value
     * @param string $abmeldedatumVorfahrzeug
     * @return \StructType\ZusaetzlicheKfzdatenType
     */
    public function setAbmeldedatumVorfahrzeug($abmeldedatumVorfahrzeug = null)
    {
        // validation for constraint: string
        if (!is_null($abmeldedatumVorfahrzeug) && !is_string($abmeldedatumVorfahrzeug)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($abmeldedatumVorfahrzeug, true), gettype($abmeldedatumVorfahrzeug)), __LINE__);
        }
        $this->abmeldedatumVorfahrzeug = $abmeldedatumVorfahrzeug;
        return $this;
    }
    /**
     * Get wechselkennzeichen value
     * @return \StructType\WechselkennzeichenType|null
     */
    public function getWechselkennzeichen()
    {
        return $this->wechselkennzeichen;
    }
    /**
     * Set wechselkennzeichen value
     * @param \StructType\WechselkennzeichenType $wechselkennzeichen
     * @return \StructType\ZusaetzlicheKfzdatenType
     */
    public function setWechselkennzeichen(\StructType\WechselkennzeichenType $wechselkennzeichen = null)
    {
        $this->wechselkennzeichen = $wechselkennzeichen;
        return $this;
    }
    /**
     * Get fahrzeugzustand value
     * @return \StructType\FahrzeugzustandType|null
     */
    public function getFahrzeugzustand()
    {
        return $this->fahrzeugzustand;
    }
    /**
     * Set fahrzeugzustand value
     * @param \StructType\FahrzeugzustandType $fahrzeugzustand
     * @return \StructType\ZusaetzlicheKfzdatenType
     */
    public function setFahrzeugzustand(\StructType\FahrzeugzustandType $fahrzeugzustand = null)
    {
        $this->fahrzeugzustand = $fahrzeugzustand;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ZusaetzlicheKfzdatenType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
