<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ZeusCarFileData StructType
 * Meta information extracted from the WSDL
 * - documentation: Cardata from File
 * @subpackage Structs
 */
class ZeusCarFileData extends AbstractStructBase
{
    /**
     * The fileName
     * Meta information extracted from the WSDL
     * - documentation: fileName
     * @var string
     */
    public $fileName;
    /**
     * The fileData
     * Meta information extracted from the WSDL
     * - documentation: fileData from file
     * @var string
     */
    public $fileData;
    /**
     * The positionInFile
     * Meta information extracted from the WSDL
     * - documentation: defines the position of the current car in the file (z.B. Wechselkennzeichen)
     * @var int
     */
    public $positionInFile;
    /**
     * Constructor method for ZeusCarFileData
     * @uses ZeusCarFileData::setFileName()
     * @uses ZeusCarFileData::setFileData()
     * @uses ZeusCarFileData::setPositionInFile()
     * @param string $fileName
     * @param string $fileData
     * @param int $positionInFile
     */
    public function __construct($fileName = null, $fileData = null, $positionInFile = null)
    {
        $this
            ->setFileName($fileName)
            ->setFileData($fileData)
            ->setPositionInFile($positionInFile);
    }
    /**
     * Get fileName value
     * @return string|null
     */
    public function getFileName()
    {
        return $this->fileName;
    }
    /**
     * Set fileName value
     * @param string $fileName
     * @return \StructType\ZeusCarFileData
     */
    public function setFileName($fileName = null)
    {
        // validation for constraint: string
        if (!is_null($fileName) && !is_string($fileName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fileName, true), gettype($fileName)), __LINE__);
        }
        $this->fileName = $fileName;
        return $this;
    }
    /**
     * Get fileData value
     * @return string|null
     */
    public function getFileData()
    {
        return $this->fileData;
    }
    /**
     * Set fileData value
     * @param string $fileData
     * @return \StructType\ZeusCarFileData
     */
    public function setFileData($fileData = null)
    {
        // validation for constraint: string
        if (!is_null($fileData) && !is_string($fileData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fileData, true), gettype($fileData)), __LINE__);
        }
        $this->fileData = $fileData;
        return $this;
    }
    /**
     * Get positionInFile value
     * @return int|null
     */
    public function getPositionInFile()
    {
        return $this->positionInFile;
    }
    /**
     * Set positionInFile value
     * @param int $positionInFile
     * @return \StructType\ZeusCarFileData
     */
    public function setPositionInFile($positionInFile = null)
    {
        // validation for constraint: int
        if (!is_null($positionInFile) && !(is_int($positionInFile) || ctype_digit($positionInFile))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($positionInFile, true), gettype($positionInFile)), __LINE__);
        }
        $this->positionInFile = $positionInFile;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ZeusCarFileData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
