<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UserToken StructType
 * @subpackage Structs
 */
class UserToken extends AbstractStructBase
{
    /**
     * The token
     * Meta information extracted from the WSDL
     * - documentation: der Token selbst in einem beliebigen Format
     * @var string
     */
    public $token;
    /**
     * The expired
     * Meta information extracted from the WSDL
     * - documentation: gültig bis
     * - minOccurs: 0
     * @var string
     */
    public $expired;
    /**
     * The deviceID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var mixed
     */
    public $deviceID;
    /**
     * The userID
     * @var mixed
     */
    public $userID;
    /**
     * The type
     * Meta information extracted from the WSDL
     * - documentation: type of token
     * @var string
     */
    public $type;
    /**
     * Constructor method for UserToken
     * @uses UserToken::setToken()
     * @uses UserToken::setExpired()
     * @uses UserToken::setDeviceID()
     * @uses UserToken::setUserID()
     * @uses UserToken::setType()
     * @param string $token
     * @param string $expired
     * @param mixed $deviceID
     * @param mixed $userID
     * @param string $type
     */
    public function __construct($token = null, $expired = null, $deviceID = null, $userID = null, $type = null)
    {
        $this
            ->setToken($token)
            ->setExpired($expired)
            ->setDeviceID($deviceID)
            ->setUserID($userID)
            ->setType($type);
    }
    /**
     * Get token value
     * @return string|null
     */
    public function getToken()
    {
        return $this->token;
    }
    /**
     * Set token value
     * @param string $token
     * @return \StructType\UserToken
     */
    public function setToken($token = null)
    {
        // validation for constraint: string
        if (!is_null($token) && !is_string($token)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($token, true), gettype($token)), __LINE__);
        }
        $this->token = $token;
        return $this;
    }
    /**
     * Get expired value
     * @return string|null
     */
    public function getExpired()
    {
        return $this->expired;
    }
    /**
     * Set expired value
     * @param string $expired
     * @return \StructType\UserToken
     */
    public function setExpired($expired = null)
    {
        // validation for constraint: string
        if (!is_null($expired) && !is_string($expired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expired, true), gettype($expired)), __LINE__);
        }
        $this->expired = $expired;
        return $this;
    }
    /**
     * Get deviceID value
     * @return mixed|null
     */
    public function getDeviceID()
    {
        return $this->deviceID;
    }
    /**
     * Set deviceID value
     * @param mixed $deviceID
     * @return \StructType\UserToken
     */
    public function setDeviceID($deviceID = null)
    {
        $this->deviceID = $deviceID;
        return $this;
    }
    /**
     * Get userID value
     * @return mixed|null
     */
    public function getUserID()
    {
        return $this->userID;
    }
    /**
     * Set userID value
     * @param mixed $userID
     * @return \StructType\UserToken
     */
    public function setUserID($userID = null)
    {
        $this->userID = $userID;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \StructType\UserToken
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UserToken
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
