<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for User StructType
 * Meta information extracted from the WSDL
 * - documentation: User
 * @subpackage Structs
 */
class User extends AbstractStructBase
{
    /**
     * The userid
     * Meta information extracted from the WSDL
     * - documentation: BenutzerID
     * - base: xsd:string
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * @var string
     */
    public $userid;
    /**
     * The role
     * Meta information extracted from the WSDL
     * - documentation: Rolle
     * - base: xsd:string
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * @var string
     */
    public $role;
    /**
     * The surename
     * Meta information extracted from the WSDL
     * - documentation: Nachname
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $surename;
    /**
     * The salutation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $salutation;
    /**
     * The firstname
     * Meta information extracted from the WSDL
     * - documentation: Vorname
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $firstname;
    /**
     * The title
     * Meta information extracted from the WSDL
     * - documentation: Berufs-, oder akademischer Titel des Kunden
     * - base: xsd:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $title;
    /**
     * The customtitle
     * Meta information extracted from the WSDL
     * - documentation: freiter Titel des Kunden
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $customtitle;
    /**
     * The telephone
     * Meta information extracted from the WSDL
     * - documentation: private Telefonnummer
     * - base: xsd:string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $telephone;
    /**
     * The email
     * Meta information extracted from the WSDL
     * - documentation: EmailAdresse | eMail Adresse
     * - base: xsd:string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $email;
    /**
     * The externalUserType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $externalUserType;
    /**
     * The address
     * Meta information extracted from the WSDL
     * - documentation: Adresse des Benutzers
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Adress
     */
    public $address;
    /**
     * The paOid
     * Meta information extracted from the WSDL
     * - documentation: paOid des kundenportal partners
     * - minOccurs: 0
     * @var string
     */
    public $paOid;
    /**
     * The kundenportalkundenbetreuer
     * Meta information extracted from the WSDL
     * - documentation: kundenbetreuer des kundenportals
     * - minOccurs: 0
     * @var int
     */
    public $kundenportalkundenbetreuer;
    /**
     * The kundenportalkundenbetreuer_yid
     * Meta information extracted from the WSDL
     * - documentation: kundenbetreuer yid des kundenportals
     * - minOccurs: 0
     * @var string
     */
    public $kundenportalkundenbetreuer_yid;
    /**
     * The kundenportalKiRegistrierung
     * Meta information extracted from the WSDL
     * - documentation: wenn true dann ist dies die erstmalige KI Registrierung
     * - minOccurs: 0
     * @var bool
     */
    public $kundenportalKiRegistrierung;
    /**
     * The electronicCommunication
     * Meta information extracted from the WSDL
     * - documentation: elektronische Kommunikation möglich
     * - minOccurs: 0
     * @var bool
     */
    public $electronicCommunication;
    /**
     * Constructor method for User
     * @uses User::setUserid()
     * @uses User::setRole()
     * @uses User::setSurename()
     * @uses User::setSalutation()
     * @uses User::setFirstname()
     * @uses User::setTitle()
     * @uses User::setCustomtitle()
     * @uses User::setTelephone()
     * @uses User::setEmail()
     * @uses User::setExternalUserType()
     * @uses User::setAddress()
     * @uses User::setPaOid()
     * @uses User::setKundenportalkundenbetreuer()
     * @uses User::setKundenportalkundenbetreuer_yid()
     * @uses User::setKundenportalKiRegistrierung()
     * @uses User::setElectronicCommunication()
     * @param string $userid
     * @param string $role
     * @param string $surename
     * @param string $salutation
     * @param string $firstname
     * @param string $title
     * @param string $customtitle
     * @param string $telephone
     * @param string $email
     * @param string $externalUserType
     * @param \StructType\Adress $address
     * @param string $paOid
     * @param int $kundenportalkundenbetreuer
     * @param string $kundenportalkundenbetreuer_yid
     * @param bool $kundenportalKiRegistrierung
     * @param bool $electronicCommunication
     */
    public function __construct($userid = null, $role = null, $surename = null, $salutation = null, $firstname = null, $title = null, $customtitle = null, $telephone = null, $email = null, $externalUserType = null, \StructType\Adress $address = null, $paOid = null, $kundenportalkundenbetreuer = null, $kundenportalkundenbetreuer_yid = null, $kundenportalKiRegistrierung = null, $electronicCommunication = null)
    {
        $this
            ->setUserid($userid)
            ->setRole($role)
            ->setSurename($surename)
            ->setSalutation($salutation)
            ->setFirstname($firstname)
            ->setTitle($title)
            ->setCustomtitle($customtitle)
            ->setTelephone($telephone)
            ->setEmail($email)
            ->setExternalUserType($externalUserType)
            ->setAddress($address)
            ->setPaOid($paOid)
            ->setKundenportalkundenbetreuer($kundenportalkundenbetreuer)
            ->setKundenportalkundenbetreuer_yid($kundenportalkundenbetreuer_yid)
            ->setKundenportalKiRegistrierung($kundenportalKiRegistrierung)
            ->setElectronicCommunication($electronicCommunication);
    }
    /**
     * Get userid value
     * @return string
     */
    public function getUserid()
    {
        return $this->userid;
    }
    /**
     * Set userid value
     * @param string $userid
     * @return \StructType\User
     */
    public function setUserid($userid = null)
    {
        // validation for constraint: string
        if (!is_null($userid) && !is_string($userid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userid, true), gettype($userid)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($userid) && mb_strlen($userid) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($userid)), __LINE__);
        }
        $this->userid = $userid;
        return $this;
    }
    /**
     * Get role value
     * @return string
     */
    public function getRole()
    {
        return $this->role;
    }
    /**
     * Set role value
     * @param string $role
     * @return \StructType\User
     */
    public function setRole($role = null)
    {
        // validation for constraint: string
        if (!is_null($role) && !is_string($role)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($role, true), gettype($role)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($role) && mb_strlen($role) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($role)), __LINE__);
        }
        $this->role = $role;
        return $this;
    }
    /**
     * Get surename value
     * @return string
     */
    public function getSurename()
    {
        return $this->surename;
    }
    /**
     * Set surename value
     * @param string $surename
     * @return \StructType\User
     */
    public function setSurename($surename = null)
    {
        // validation for constraint: string
        if (!is_null($surename) && !is_string($surename)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($surename, true), gettype($surename)), __LINE__);
        }
        $this->surename = $surename;
        return $this;
    }
    /**
     * Get salutation value
     * @return string
     */
    public function getSalutation()
    {
        return $this->salutation;
    }
    /**
     * Set salutation value
     * @uses \EnumType\Salutation::valueIsValid()
     * @uses \EnumType\Salutation::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $salutation
     * @return \StructType\User
     */
    public function setSalutation($salutation = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Salutation::valueIsValid($salutation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Salutation', is_array($salutation) ? implode(', ', $salutation) : var_export($salutation, true), implode(', ', \EnumType\Salutation::getValidValues())), __LINE__);
        }
        $this->salutation = $salutation;
        return $this;
    }
    /**
     * Get firstname value
     * @return string|null
     */
    public function getFirstname()
    {
        return $this->firstname;
    }
    /**
     * Set firstname value
     * @param string $firstname
     * @return \StructType\User
     */
    public function setFirstname($firstname = null)
    {
        // validation for constraint: string
        if (!is_null($firstname) && !is_string($firstname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstname, true), gettype($firstname)), __LINE__);
        }
        $this->firstname = $firstname;
        return $this;
    }
    /**
     * Get title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->title;
    }
    /**
     * Set title value
     * @param string $title
     * @return \StructType\User
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($title) && mb_strlen($title) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($title)), __LINE__);
        }
        $this->title = $title;
        return $this;
    }
    /**
     * Get customtitle value
     * @return string|null
     */
    public function getCustomtitle()
    {
        return $this->customtitle;
    }
    /**
     * Set customtitle value
     * @param string $customtitle
     * @return \StructType\User
     */
    public function setCustomtitle($customtitle = null)
    {
        // validation for constraint: string
        if (!is_null($customtitle) && !is_string($customtitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customtitle, true), gettype($customtitle)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($customtitle) && mb_strlen($customtitle) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($customtitle)), __LINE__);
        }
        $this->customtitle = $customtitle;
        return $this;
    }
    /**
     * Get telephone value
     * @return string|null
     */
    public function getTelephone()
    {
        return $this->telephone;
    }
    /**
     * Set telephone value
     * @param string $telephone
     * @return \StructType\User
     */
    public function setTelephone($telephone = null)
    {
        // validation for constraint: string
        if (!is_null($telephone) && !is_string($telephone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($telephone, true), gettype($telephone)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($telephone) && mb_strlen($telephone) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($telephone)), __LINE__);
        }
        $this->telephone = $telephone;
        return $this;
    }
    /**
     * Get email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return \StructType\User
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($email) && mb_strlen($email) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($email)), __LINE__);
        }
        $this->email = $email;
        return $this;
    }
    /**
     * Get externalUserType value
     * @return string|null
     */
    public function getExternalUserType()
    {
        return $this->externalUserType;
    }
    /**
     * Set externalUserType value
     * @uses \EnumType\ExternalUserType::valueIsValid()
     * @uses \EnumType\ExternalUserType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $externalUserType
     * @return \StructType\User
     */
    public function setExternalUserType($externalUserType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ExternalUserType::valueIsValid($externalUserType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ExternalUserType', is_array($externalUserType) ? implode(', ', $externalUserType) : var_export($externalUserType, true), implode(', ', \EnumType\ExternalUserType::getValidValues())), __LINE__);
        }
        $this->externalUserType = $externalUserType;
        return $this;
    }
    /**
     * Get address value
     * @return \StructType\Adress|null
     */
    public function getAddress()
    {
        return $this->address;
    }
    /**
     * Set address value
     * @param \StructType\Adress $address
     * @return \StructType\User
     */
    public function setAddress(\StructType\Adress $address = null)
    {
        $this->address = $address;
        return $this;
    }
    /**
     * Get paOid value
     * @return string|null
     */
    public function getPaOid()
    {
        return $this->paOid;
    }
    /**
     * Set paOid value
     * @param string $paOid
     * @return \StructType\User
     */
    public function setPaOid($paOid = null)
    {
        // validation for constraint: string
        if (!is_null($paOid) && !is_string($paOid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paOid, true), gettype($paOid)), __LINE__);
        }
        $this->paOid = $paOid;
        return $this;
    }
    /**
     * Get kundenportalkundenbetreuer value
     * @return int|null
     */
    public function getKundenportalkundenbetreuer()
    {
        return $this->kundenportalkundenbetreuer;
    }
    /**
     * Set kundenportalkundenbetreuer value
     * @param int $kundenportalkundenbetreuer
     * @return \StructType\User
     */
    public function setKundenportalkundenbetreuer($kundenportalkundenbetreuer = null)
    {
        // validation for constraint: int
        if (!is_null($kundenportalkundenbetreuer) && !(is_int($kundenportalkundenbetreuer) || ctype_digit($kundenportalkundenbetreuer))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($kundenportalkundenbetreuer, true), gettype($kundenportalkundenbetreuer)), __LINE__);
        }
        $this->kundenportalkundenbetreuer = $kundenportalkundenbetreuer;
        return $this;
    }
    /**
     * Get kundenportalkundenbetreuer_yid value
     * @return string|null
     */
    public function getKundenportalkundenbetreuer_yid()
    {
        return $this->kundenportalkundenbetreuer_yid;
    }
    /**
     * Set kundenportalkundenbetreuer_yid value
     * @param string $kundenportalkundenbetreuer_yid
     * @return \StructType\User
     */
    public function setKundenportalkundenbetreuer_yid($kundenportalkundenbetreuer_yid = null)
    {
        // validation for constraint: string
        if (!is_null($kundenportalkundenbetreuer_yid) && !is_string($kundenportalkundenbetreuer_yid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kundenportalkundenbetreuer_yid, true), gettype($kundenportalkundenbetreuer_yid)), __LINE__);
        }
        $this->kundenportalkundenbetreuer_yid = $kundenportalkundenbetreuer_yid;
        return $this;
    }
    /**
     * Get kundenportalKiRegistrierung value
     * @return bool|null
     */
    public function getKundenportalKiRegistrierung()
    {
        return $this->kundenportalKiRegistrierung;
    }
    /**
     * Set kundenportalKiRegistrierung value
     * @param bool $kundenportalKiRegistrierung
     * @return \StructType\User
     */
    public function setKundenportalKiRegistrierung($kundenportalKiRegistrierung = null)
    {
        // validation for constraint: boolean
        if (!is_null($kundenportalKiRegistrierung) && !is_bool($kundenportalKiRegistrierung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($kundenportalKiRegistrierung, true), gettype($kundenportalKiRegistrierung)), __LINE__);
        }
        $this->kundenportalKiRegistrierung = $kundenportalKiRegistrierung;
        return $this;
    }
    /**
     * Get electronicCommunication value
     * @return bool|null
     */
    public function getElectronicCommunication()
    {
        return $this->electronicCommunication;
    }
    /**
     * Set electronicCommunication value
     * @param bool $electronicCommunication
     * @return \StructType\User
     */
    public function setElectronicCommunication($electronicCommunication = null)
    {
        // validation for constraint: boolean
        if (!is_null($electronicCommunication) && !is_bool($electronicCommunication)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($electronicCommunication, true), gettype($electronicCommunication)), __LINE__);
        }
        $this->electronicCommunication = $electronicCommunication;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\User
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
