<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TreatmentBill StructType
 * Meta information extracted from the WSDL
 * - documentation: Ein Rechnungsblock in der ambulaten Leistungsmeldung
 * @subpackage Structs
 */
class TreatmentBill extends AbstractStructBase
{
    /**
     * The typeOfTreatment
     * @var \StructType\BehandlerArtKP
     */
    public $typeOfTreatment;
    /**
     * The treatmentBegin
     * @var string
     */
    public $treatmentBegin;
    /**
     * The treatmentEnd
     * @var string
     */
    public $treatmentEnd;
    /**
     * The practioner
     * @var \StructType\BehandlerVZ
     */
    public $practioner;
    /**
     * The diagnose
     * @var string
     */
    public $diagnose;
    /**
     * The amount
     * @var float
     */
    public $amount;
    /**
     * The availableRegulation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $availableRegulation;
    /**
     * The currency
     * @var string
     */
    public $currency;
    /**
     * The socialInsurance
     * @var bool
     */
    public $socialInsurance;
    /**
     * The amountRefundbySocialInsurance
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $amountRefundbySocialInsurance;
    /**
     * The comment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $comment;
    /**
     * The attachment
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\Attachment[]
     */
    public $attachment;
    /**
     * Constructor method for TreatmentBill
     * @uses TreatmentBill::setTypeOfTreatment()
     * @uses TreatmentBill::setTreatmentBegin()
     * @uses TreatmentBill::setTreatmentEnd()
     * @uses TreatmentBill::setPractioner()
     * @uses TreatmentBill::setDiagnose()
     * @uses TreatmentBill::setAmount()
     * @uses TreatmentBill::setAvailableRegulation()
     * @uses TreatmentBill::setCurrency()
     * @uses TreatmentBill::setSocialInsurance()
     * @uses TreatmentBill::setAmountRefundbySocialInsurance()
     * @uses TreatmentBill::setComment()
     * @uses TreatmentBill::setAttachment()
     * @param \StructType\BehandlerArtKP $typeOfTreatment
     * @param string $treatmentBegin
     * @param string $treatmentEnd
     * @param \StructType\BehandlerVZ $practioner
     * @param string $diagnose
     * @param float $amount
     * @param bool $availableRegulation
     * @param string $currency
     * @param bool $socialInsurance
     * @param float $amountRefundbySocialInsurance
     * @param string $comment
     * @param \StructType\Attachment[] $attachment
     */
    public function __construct(\StructType\BehandlerArtKP $typeOfTreatment = null, $treatmentBegin = null, $treatmentEnd = null, \StructType\BehandlerVZ $practioner = null, $diagnose = null, $amount = null, $availableRegulation = null, $currency = null, $socialInsurance = null, $amountRefundbySocialInsurance = null, $comment = null, array $attachment = array())
    {
        $this
            ->setTypeOfTreatment($typeOfTreatment)
            ->setTreatmentBegin($treatmentBegin)
            ->setTreatmentEnd($treatmentEnd)
            ->setPractioner($practioner)
            ->setDiagnose($diagnose)
            ->setAmount($amount)
            ->setAvailableRegulation($availableRegulation)
            ->setCurrency($currency)
            ->setSocialInsurance($socialInsurance)
            ->setAmountRefundbySocialInsurance($amountRefundbySocialInsurance)
            ->setComment($comment)
            ->setAttachment($attachment);
    }
    /**
     * Get typeOfTreatment value
     * @return \StructType\BehandlerArtKP|null
     */
    public function getTypeOfTreatment()
    {
        return $this->typeOfTreatment;
    }
    /**
     * Set typeOfTreatment value
     * @param \StructType\BehandlerArtKP $typeOfTreatment
     * @return \StructType\TreatmentBill
     */
    public function setTypeOfTreatment(\StructType\BehandlerArtKP $typeOfTreatment = null)
    {
        $this->typeOfTreatment = $typeOfTreatment;
        return $this;
    }
    /**
     * Get treatmentBegin value
     * @return string|null
     */
    public function getTreatmentBegin()
    {
        return $this->treatmentBegin;
    }
    /**
     * Set treatmentBegin value
     * @param string $treatmentBegin
     * @return \StructType\TreatmentBill
     */
    public function setTreatmentBegin($treatmentBegin = null)
    {
        // validation for constraint: string
        if (!is_null($treatmentBegin) && !is_string($treatmentBegin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($treatmentBegin, true), gettype($treatmentBegin)), __LINE__);
        }
        $this->treatmentBegin = $treatmentBegin;
        return $this;
    }
    /**
     * Get treatmentEnd value
     * @return string|null
     */
    public function getTreatmentEnd()
    {
        return $this->treatmentEnd;
    }
    /**
     * Set treatmentEnd value
     * @param string $treatmentEnd
     * @return \StructType\TreatmentBill
     */
    public function setTreatmentEnd($treatmentEnd = null)
    {
        // validation for constraint: string
        if (!is_null($treatmentEnd) && !is_string($treatmentEnd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($treatmentEnd, true), gettype($treatmentEnd)), __LINE__);
        }
        $this->treatmentEnd = $treatmentEnd;
        return $this;
    }
    /**
     * Get practioner value
     * @return \StructType\BehandlerVZ|null
     */
    public function getPractioner()
    {
        return $this->practioner;
    }
    /**
     * Set practioner value
     * @param \StructType\BehandlerVZ $practioner
     * @return \StructType\TreatmentBill
     */
    public function setPractioner(\StructType\BehandlerVZ $practioner = null)
    {
        $this->practioner = $practioner;
        return $this;
    }
    /**
     * Get diagnose value
     * @return string|null
     */
    public function getDiagnose()
    {
        return $this->diagnose;
    }
    /**
     * Set diagnose value
     * @param string $diagnose
     * @return \StructType\TreatmentBill
     */
    public function setDiagnose($diagnose = null)
    {
        // validation for constraint: string
        if (!is_null($diagnose) && !is_string($diagnose)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($diagnose, true), gettype($diagnose)), __LINE__);
        }
        $this->diagnose = $diagnose;
        return $this;
    }
    /**
     * Get amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param float $amount
     * @return \StructType\TreatmentBill
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->amount = $amount;
        return $this;
    }
    /**
     * Get availableRegulation value
     * @return bool|null
     */
    public function getAvailableRegulation()
    {
        return $this->availableRegulation;
    }
    /**
     * Set availableRegulation value
     * @param bool $availableRegulation
     * @return \StructType\TreatmentBill
     */
    public function setAvailableRegulation($availableRegulation = null)
    {
        // validation for constraint: boolean
        if (!is_null($availableRegulation) && !is_bool($availableRegulation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($availableRegulation, true), gettype($availableRegulation)), __LINE__);
        }
        $this->availableRegulation = $availableRegulation;
        return $this;
    }
    /**
     * Get currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @uses \EnumType\Currency::valueIsValid()
     * @uses \EnumType\Currency::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $currency
     * @return \StructType\TreatmentBill
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Currency::valueIsValid($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Currency', is_array($currency) ? implode(', ', $currency) : var_export($currency, true), implode(', ', \EnumType\Currency::getValidValues())), __LINE__);
        }
        $this->currency = $currency;
        return $this;
    }
    /**
     * Get socialInsurance value
     * @return bool|null
     */
    public function getSocialInsurance()
    {
        return $this->socialInsurance;
    }
    /**
     * Set socialInsurance value
     * @param bool $socialInsurance
     * @return \StructType\TreatmentBill
     */
    public function setSocialInsurance($socialInsurance = null)
    {
        // validation for constraint: boolean
        if (!is_null($socialInsurance) && !is_bool($socialInsurance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($socialInsurance, true), gettype($socialInsurance)), __LINE__);
        }
        $this->socialInsurance = $socialInsurance;
        return $this;
    }
    /**
     * Get amountRefundbySocialInsurance value
     * @return float|null
     */
    public function getAmountRefundbySocialInsurance()
    {
        return $this->amountRefundbySocialInsurance;
    }
    /**
     * Set amountRefundbySocialInsurance value
     * @param float $amountRefundbySocialInsurance
     * @return \StructType\TreatmentBill
     */
    public function setAmountRefundbySocialInsurance($amountRefundbySocialInsurance = null)
    {
        // validation for constraint: float
        if (!is_null($amountRefundbySocialInsurance) && !(is_float($amountRefundbySocialInsurance) || is_numeric($amountRefundbySocialInsurance))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amountRefundbySocialInsurance, true), gettype($amountRefundbySocialInsurance)), __LINE__);
        }
        $this->amountRefundbySocialInsurance = $amountRefundbySocialInsurance;
        return $this;
    }
    /**
     * Get comment value
     * @return string|null
     */
    public function getComment()
    {
        return $this->comment;
    }
    /**
     * Set comment value
     * @param string $comment
     * @return \StructType\TreatmentBill
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comment, true), gettype($comment)), __LINE__);
        }
        $this->comment = $comment;
        return $this;
    }
    /**
     * Get attachment value
     * @return \StructType\Attachment[]|null
     */
    public function getAttachment()
    {
        return $this->attachment;
    }
    /**
     * This method is responsible for validating the values passed to the setAttachment method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAttachment method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAttachmentForArrayConstraintsFromSetAttachment(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $treatmentBillAttachmentItem) {
            // validation for constraint: itemType
            if (!$treatmentBillAttachmentItem instanceof \StructType\Attachment) {
                $invalidValues[] = is_object($treatmentBillAttachmentItem) ? get_class($treatmentBillAttachmentItem) : sprintf('%s(%s)', gettype($treatmentBillAttachmentItem), var_export($treatmentBillAttachmentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The attachment property can only contain items of type \StructType\Attachment, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set attachment value
     * @throws \InvalidArgumentException
     * @param \StructType\Attachment[] $attachment
     * @return \StructType\TreatmentBill
     */
    public function setAttachment(array $attachment = array())
    {
        // validation for constraint: array
        if ('' !== ($attachmentArrayErrorMessage = self::validateAttachmentForArrayConstraintsFromSetAttachment($attachment))) {
            throw new \InvalidArgumentException($attachmentArrayErrorMessage, __LINE__);
        }
        $this->attachment = $attachment;
        return $this;
    }
    /**
     * Add item to attachment value
     * @throws \InvalidArgumentException
     * @param \StructType\Attachment $item
     * @return \StructType\TreatmentBill
     */
    public function addToAttachment(\StructType\Attachment $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Attachment) {
            throw new \InvalidArgumentException(sprintf('The attachment property can only contain items of type \StructType\Attachment, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->attachment[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TreatmentBill
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
