<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for transferBusinessCasesRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Request um die Übertragung mehrerer Geschäftsfalle anzustoßen
 * @subpackage Structs
 */
class TransferBusinessCasesRequest extends AbstractStructBase
{
    /**
     * The login
     * Meta information extracted from the WSDL
     * - documentation: login user
     * @var \StructType\Login
     */
    public $login;
    /**
     * The documentID
     * Meta information extracted from the WSDL
     * - documentation: Generali-interne ID zum Referenzieren der Geschäftsfälle
     * - base: xsd:string
     * - maxLength: 23
     * - maxOccurs: unbounded
     * @var string[]
     */
    public $documentID;
    /**
     * The externalUserID
     * Meta information extracted from the WSDL
     * - documentation: externe UserID die im Antrags Header gesendet wird
     * - base: xsd:string
     * - maxLength: 100
     * - minOccurs: 0
     * @var string
     */
    public $externalUserID;
    /**
     * The check
     * Meta information extracted from the WSDL
     * - documentation: soll beim übertragen auf berechtigung geprüft werden
     * - base: xsd:boolean
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $check;
    /**
     * Constructor method for transferBusinessCasesRequest
     * @uses TransferBusinessCasesRequest::setLogin()
     * @uses TransferBusinessCasesRequest::setDocumentID()
     * @uses TransferBusinessCasesRequest::setExternalUserID()
     * @uses TransferBusinessCasesRequest::setCheck()
     * @param \StructType\Login $login
     * @param string[] $documentID
     * @param string $externalUserID
     * @param bool $check
     */
    public function __construct(\StructType\Login $login = null, array $documentID = array(), $externalUserID = null, $check = true)
    {
        $this
            ->setLogin($login)
            ->setDocumentID($documentID)
            ->setExternalUserID($externalUserID)
            ->setCheck($check);
    }
    /**
     * Get login value
     * @return \StructType\Login|null
     */
    public function getLogin()
    {
        return $this->login;
    }
    /**
     * Set login value
     * @param \StructType\Login $login
     * @return \StructType\TransferBusinessCasesRequest
     */
    public function setLogin(\StructType\Login $login = null)
    {
        $this->login = $login;
        return $this;
    }
    /**
     * Get documentID value
     * @return string[]|null
     */
    public function getDocumentID()
    {
        return $this->documentID;
    }
    /**
     * This method is responsible for validating the values passed to the setDocumentID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDocumentID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDocumentIDForArrayConstraintsFromSetDocumentID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $transferBusinessCasesRequestDocumentIDItem) {
            // validation for constraint: itemType
            if (!is_string($transferBusinessCasesRequestDocumentIDItem)) {
                $invalidValues[] = is_object($transferBusinessCasesRequestDocumentIDItem) ? get_class($transferBusinessCasesRequestDocumentIDItem) : sprintf('%s(%s)', gettype($transferBusinessCasesRequestDocumentIDItem), var_export($transferBusinessCasesRequestDocumentIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The documentID property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setDocumentID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDocumentID method
     * This has to validate that the items contained by the array match the length constraint
     * @param mixed $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDocumentIDForMaxLengthConstraintFromSetDocumentID($values)
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $transferBusinessCasesRequestDocumentIDItem) {
            // validation for constraint: maxLength(23)
            if (mb_strlen($transferBusinessCasesRequestDocumentIDItem) > 23) {
                $invalidValues[] = var_export($transferBusinessCasesRequestDocumentIDItem, true);
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid length for value(s) %s, the number of characters/octets contained by the literal must be less than or equal to 23', implode(', ', $invalidValues));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set documentID value
     * @throws \InvalidArgumentException
     * @param string[] $documentID
     * @return \StructType\TransferBusinessCasesRequest
     */
    public function setDocumentID(array $documentID = array())
    {
        // validation for constraint: array
        if ('' !== ($documentIDArrayErrorMessage = self::validateDocumentIDForArrayConstraintsFromSetDocumentID($documentID))) {
            throw new \InvalidArgumentException($documentIDArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxLength(23)
        if ('' !== ($documentIDMaxLengthErrorMessage = self::validateDocumentIDForMaxLengthConstraintFromSetDocumentID($documentID))) {
            throw new \InvalidArgumentException($documentIDMaxLengthErrorMessage, __LINE__);
        }
        $this->documentID = $documentID;
        return $this;
    }
    /**
     * Add item to documentID value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\TransferBusinessCasesRequest
     */
    public function addToDocumentID($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The documentID property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxLength(23)
        if (mb_strlen($item) > 23) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 23', mb_strlen($item)), __LINE__);
        }
        $this->documentID[] = $item;
        return $this;
    }
    /**
     * Get externalUserID value
     * @return string|null
     */
    public function getExternalUserID()
    {
        return $this->externalUserID;
    }
    /**
     * Set externalUserID value
     * @param string $externalUserID
     * @return \StructType\TransferBusinessCasesRequest
     */
    public function setExternalUserID($externalUserID = null)
    {
        // validation for constraint: string
        if (!is_null($externalUserID) && !is_string($externalUserID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalUserID, true), gettype($externalUserID)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($externalUserID) && mb_strlen($externalUserID) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($externalUserID)), __LINE__);
        }
        $this->externalUserID = $externalUserID;
        return $this;
    }
    /**
     * Get check value
     * @return bool|null
     */
    public function getCheck()
    {
        return $this->check;
    }
    /**
     * Set check value
     * @param bool $check
     * @return \StructType\TransferBusinessCasesRequest
     */
    public function setCheck($check = true)
    {
        // validation for constraint: boolean
        if (!is_null($check) && !is_bool($check)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($check, true), gettype($check)), __LINE__);
        }
        $this->check = $check;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TransferBusinessCasesRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
