<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for State StructType
 * Meta information extracted from the WSDL
 * - documentation: State-Objekt
 * @subpackage Structs
 */
class State extends AbstractStructBase
{
    /**
     * The key
     * Meta information extracted from the WSDL
     * - documentation: String key of the attribute. If 'VPMS/A_test' is used the key is mapped to VPMS | Status key aus der Datenbank. Z.b. 90 ... Angebot
     * - base: xsd:string
     * - maxLength: 50
     * - minLength: 5
     * @var string
     */
    public $key;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - documentation: Sonstige Beschreibung des Attachements | Freie Beschreibung des Geschäftsfalles | Beschreibung des Status
     * - base: xsd:string
     * - maxLength: 30
     * - minLength: 5
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * Constructor method for State
     * @uses State::setKey()
     * @uses State::setDescription()
     * @param string $key
     * @param string $description
     */
    public function __construct($key = null, $description = null)
    {
        $this
            ->setKey($key)
            ->setDescription($description);
    }
    /**
     * Get key value
     * @return string|null
     */
    public function getKey()
    {
        return $this->key;
    }
    /**
     * Set key value
     * @param string $key
     * @return \StructType\State
     */
    public function setKey($key = null)
    {
        // validation for constraint: string
        if (!is_null($key) && !is_string($key)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($key, true), gettype($key)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($key) && mb_strlen($key) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($key)), __LINE__);
        }
        // validation for constraint: minLength(5)
        if (!is_null($key) && mb_strlen($key) < 5) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 5', mb_strlen($key)), __LINE__);
        }
        $this->key = $key;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\State
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($description) && mb_strlen($description) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($description)), __LINE__);
        }
        // validation for constraint: minLength(5)
        if (!is_null($description) && mb_strlen($description) < 5) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 5', mb_strlen($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\State
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
