<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for sonderrabattType StructType
 * @subpackage Structs
 */
class SonderrabattType extends AbstractStructBase
{
    /**
     * The sonderrabatt
     * Meta information extracted from the WSDL
     * - base: xs:decimal
     * - fractionDigits: 2
     * - maxInclusive: 100
     * - minInclusive: 0
     * @var float
     */
    public $sonderrabatt;
    /**
     * The rabattgrund
     * @var string
     */
    public $rabattgrund;
    /**
     * Constructor method for sonderrabattType
     * @uses SonderrabattType::setSonderrabatt()
     * @uses SonderrabattType::setRabattgrund()
     * @param float $sonderrabatt
     * @param string $rabattgrund
     */
    public function __construct($sonderrabatt = null, $rabattgrund = null)
    {
        $this
            ->setSonderrabatt($sonderrabatt)
            ->setRabattgrund($rabattgrund);
    }
    /**
     * Get sonderrabatt value
     * @return float|null
     */
    public function getSonderrabatt()
    {
        return $this->sonderrabatt;
    }
    /**
     * Set sonderrabatt value
     * @param float $sonderrabatt
     * @return \StructType\SonderrabattType
     */
    public function setSonderrabatt($sonderrabatt = null)
    {
        // validation for constraint: float
        if (!is_null($sonderrabatt) && !(is_float($sonderrabatt) || is_numeric($sonderrabatt))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($sonderrabatt, true), gettype($sonderrabatt)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($sonderrabatt) && mb_strlen(mb_substr($sonderrabatt, mb_strpos($sonderrabatt, '.') + 1)) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($sonderrabatt, true), mb_strlen(mb_substr($sonderrabatt, mb_strpos($sonderrabatt, '.') + 1))), __LINE__);
        }
        // validation for constraint: maxInclusive(100)
        if (!is_null($sonderrabatt) && $sonderrabatt > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 100', var_export($sonderrabatt, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($sonderrabatt) && $sonderrabatt < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($sonderrabatt, true)), __LINE__);
        }
        $this->sonderrabatt = $sonderrabatt;
        return $this;
    }
    /**
     * Get rabattgrund value
     * @return string|null
     */
    public function getRabattgrund()
    {
        return $this->rabattgrund;
    }
    /**
     * Set rabattgrund value
     * @uses \EnumType\RabattgrundType::valueIsValid()
     * @uses \EnumType\RabattgrundType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $rabattgrund
     * @return \StructType\SonderrabattType
     */
    public function setRabattgrund($rabattgrund = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RabattgrundType::valueIsValid($rabattgrund)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\RabattgrundType', is_array($rabattgrund) ? implode(', ', $rabattgrund) : var_export($rabattgrund, true), implode(', ', \EnumType\RabattgrundType::getValidValues())), __LINE__);
        }
        $this->rabattgrund = $rabattgrund;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SonderrabattType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
