<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SignableDocumentType StructType
 * Meta information extracted from the WSDL
 * - documentation: Informationen zu einem unterschreibbaren Dokument
 * @subpackage Structs
 */
class SignableDocumentType extends AbstractStructBase
{
    /**
     * The documentName
     * @var string
     */
    public $documentName;
    /**
     * The documentId
     * @var int
     */
    public $documentId;
    /**
     * The documentTypVorlage
     * @var int
     */
    public $documentTypVorlage;
    /**
     * The documentSigner
     * @var string
     */
    public $documentSigner;
    /**
     * The documentSignGroupId
     * @var int
     */
    public $documentSignGroupId;
    /**
     * The printData
     * Meta information extracted from the WSDL
     * - documentation: Der PDF-Stream des unterschriebenen Druckdokuments im Response
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $printData;
    /**
     * Constructor method for SignableDocumentType
     * @uses SignableDocumentType::setDocumentName()
     * @uses SignableDocumentType::setDocumentId()
     * @uses SignableDocumentType::setDocumentTypVorlage()
     * @uses SignableDocumentType::setDocumentSigner()
     * @uses SignableDocumentType::setDocumentSignGroupId()
     * @uses SignableDocumentType::setPrintData()
     * @param string $documentName
     * @param int $documentId
     * @param int $documentTypVorlage
     * @param string $documentSigner
     * @param int $documentSignGroupId
     * @param string $printData
     */
    public function __construct($documentName = null, $documentId = null, $documentTypVorlage = null, $documentSigner = null, $documentSignGroupId = null, $printData = null)
    {
        $this
            ->setDocumentName($documentName)
            ->setDocumentId($documentId)
            ->setDocumentTypVorlage($documentTypVorlage)
            ->setDocumentSigner($documentSigner)
            ->setDocumentSignGroupId($documentSignGroupId)
            ->setPrintData($printData);
    }
    /**
     * Get documentName value
     * @return string|null
     */
    public function getDocumentName()
    {
        return $this->documentName;
    }
    /**
     * Set documentName value
     * @param string $documentName
     * @return \StructType\SignableDocumentType
     */
    public function setDocumentName($documentName = null)
    {
        // validation for constraint: string
        if (!is_null($documentName) && !is_string($documentName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentName, true), gettype($documentName)), __LINE__);
        }
        $this->documentName = $documentName;
        return $this;
    }
    /**
     * Get documentId value
     * @return int|null
     */
    public function getDocumentId()
    {
        return $this->documentId;
    }
    /**
     * Set documentId value
     * @param int $documentId
     * @return \StructType\SignableDocumentType
     */
    public function setDocumentId($documentId = null)
    {
        // validation for constraint: int
        if (!is_null($documentId) && !(is_int($documentId) || ctype_digit($documentId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($documentId, true), gettype($documentId)), __LINE__);
        }
        $this->documentId = $documentId;
        return $this;
    }
    /**
     * Get documentTypVorlage value
     * @return int|null
     */
    public function getDocumentTypVorlage()
    {
        return $this->documentTypVorlage;
    }
    /**
     * Set documentTypVorlage value
     * @param int $documentTypVorlage
     * @return \StructType\SignableDocumentType
     */
    public function setDocumentTypVorlage($documentTypVorlage = null)
    {
        // validation for constraint: int
        if (!is_null($documentTypVorlage) && !(is_int($documentTypVorlage) || ctype_digit($documentTypVorlage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($documentTypVorlage, true), gettype($documentTypVorlage)), __LINE__);
        }
        $this->documentTypVorlage = $documentTypVorlage;
        return $this;
    }
    /**
     * Get documentSigner value
     * @return string|null
     */
    public function getDocumentSigner()
    {
        return $this->documentSigner;
    }
    /**
     * Set documentSigner value
     * @param string $documentSigner
     * @return \StructType\SignableDocumentType
     */
    public function setDocumentSigner($documentSigner = null)
    {
        // validation for constraint: string
        if (!is_null($documentSigner) && !is_string($documentSigner)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentSigner, true), gettype($documentSigner)), __LINE__);
        }
        $this->documentSigner = $documentSigner;
        return $this;
    }
    /**
     * Get documentSignGroupId value
     * @return int|null
     */
    public function getDocumentSignGroupId()
    {
        return $this->documentSignGroupId;
    }
    /**
     * Set documentSignGroupId value
     * @param int $documentSignGroupId
     * @return \StructType\SignableDocumentType
     */
    public function setDocumentSignGroupId($documentSignGroupId = null)
    {
        // validation for constraint: int
        if (!is_null($documentSignGroupId) && !(is_int($documentSignGroupId) || ctype_digit($documentSignGroupId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($documentSignGroupId, true), gettype($documentSignGroupId)), __LINE__);
        }
        $this->documentSignGroupId = $documentSignGroupId;
        return $this;
    }
    /**
     * Get printData value
     * @return string|null
     */
    public function getPrintData()
    {
        return $this->printData;
    }
    /**
     * Set printData value
     * @param string $printData
     * @return \StructType\SignableDocumentType
     */
    public function setPrintData($printData = null)
    {
        // validation for constraint: string
        if (!is_null($printData) && !is_string($printData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($printData, true), gettype($printData)), __LINE__);
        }
        $this->printData = $printData;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SignableDocumentType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
