<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for sendCustomerRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Request um Kunden in der eVP anzulegen oder zu aktualisieren
 * @subpackage Structs
 */
class SendCustomerRequest extends AbstractStructBase
{
    /**
     * The login
     * @var \StructType\Login
     */
    public $login;
    /**
     * The customer
     * @var \StructType\Customer
     */
    public $customer;
    /**
     * The withGui
     * Meta information extracted from the WSDL
     * - documentation: Startet die GUI Variante der Partnerdaten Eingabe
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $withGui;
    /**
     * Constructor method for sendCustomerRequest
     * @uses SendCustomerRequest::setLogin()
     * @uses SendCustomerRequest::setCustomer()
     * @uses SendCustomerRequest::setWithGui()
     * @param \StructType\Login $login
     * @param \StructType\Customer $customer
     * @param bool $withGui
     */
    public function __construct(\StructType\Login $login = null, \StructType\Customer $customer = null, $withGui = false)
    {
        $this
            ->setLogin($login)
            ->setCustomer($customer)
            ->setWithGui($withGui);
    }
    /**
     * Get login value
     * @return \StructType\Login|null
     */
    public function getLogin()
    {
        return $this->login;
    }
    /**
     * Set login value
     * @param \StructType\Login $login
     * @return \StructType\SendCustomerRequest
     */
    public function setLogin(\StructType\Login $login = null)
    {
        $this->login = $login;
        return $this;
    }
    /**
     * Get customer value
     * @return \StructType\Customer|null
     */
    public function getCustomer()
    {
        return $this->customer;
    }
    /**
     * Set customer value
     * @param \StructType\Customer $customer
     * @return \StructType\SendCustomerRequest
     */
    public function setCustomer(\StructType\Customer $customer = null)
    {
        $this->customer = $customer;
        return $this;
    }
    /**
     * Get withGui value
     * @return bool|null
     */
    public function getWithGui()
    {
        return $this->withGui;
    }
    /**
     * Set withGui value
     * @param bool $withGui
     * @return \StructType\SendCustomerRequest
     */
    public function setWithGui($withGui = false)
    {
        // validation for constraint: boolean
        if (!is_null($withGui) && !is_bool($withGui)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($withGui, true), gettype($withGui)), __LINE__);
        }
        $this->withGui = $withGui;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SendCustomerRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
