<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for searchContractListResponse StructType
 * Meta information extracted from the WSDL
 * - documentation: Response zum Suchen von Verträgen
 * @subpackage Structs
 */
class SearchContractListResponse extends AbstractStructBase
{
    /**
     * The contractResult
     * Meta information extracted from the WSDL
     * - documentation: 0...n Ergebnisse
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ContractSearchDetail[]
     */
    public $contractResult;
    /**
     * The outstandingPayment
     * @var bool
     */
    public $outstandingPayment;
    /**
     * The evpServiceFault
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\EvpServiceFault
     */
    public $evpServiceFault;
    /**
     * The hasCustomerAccountPayment
     * @var bool
     */
    public $hasCustomerAccountPayment;
    /**
     * Constructor method for searchContractListResponse
     * @uses SearchContractListResponse::setContractResult()
     * @uses SearchContractListResponse::setOutstandingPayment()
     * @uses SearchContractListResponse::setEvpServiceFault()
     * @uses SearchContractListResponse::setHasCustomerAccountPayment()
     * @param \StructType\ContractSearchDetail[] $contractResult
     * @param bool $outstandingPayment
     * @param \StructType\EvpServiceFault $evpServiceFault
     * @param bool $hasCustomerAccountPayment
     */
    public function __construct(array $contractResult = array(), $outstandingPayment = null, \StructType\EvpServiceFault $evpServiceFault = null, $hasCustomerAccountPayment = null)
    {
        $this
            ->setContractResult($contractResult)
            ->setOutstandingPayment($outstandingPayment)
            ->setEvpServiceFault($evpServiceFault)
            ->setHasCustomerAccountPayment($hasCustomerAccountPayment);
    }
    /**
     * Get contractResult value
     * @return \StructType\ContractSearchDetail[]|null
     */
    public function getContractResult()
    {
        return $this->contractResult;
    }
    /**
     * This method is responsible for validating the values passed to the setContractResult method
     * This method is willingly generated in order to preserve the one-line inline validation within the setContractResult method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateContractResultForArrayConstraintsFromSetContractResult(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $searchContractListResponseContractResultItem) {
            // validation for constraint: itemType
            if (!$searchContractListResponseContractResultItem instanceof \StructType\ContractSearchDetail) {
                $invalidValues[] = is_object($searchContractListResponseContractResultItem) ? get_class($searchContractListResponseContractResultItem) : sprintf('%s(%s)', gettype($searchContractListResponseContractResultItem), var_export($searchContractListResponseContractResultItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The contractResult property can only contain items of type \StructType\ContractSearchDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set contractResult value
     * @throws \InvalidArgumentException
     * @param \StructType\ContractSearchDetail[] $contractResult
     * @return \StructType\SearchContractListResponse
     */
    public function setContractResult(array $contractResult = array())
    {
        // validation for constraint: array
        if ('' !== ($contractResultArrayErrorMessage = self::validateContractResultForArrayConstraintsFromSetContractResult($contractResult))) {
            throw new \InvalidArgumentException($contractResultArrayErrorMessage, __LINE__);
        }
        $this->contractResult = $contractResult;
        return $this;
    }
    /**
     * Add item to contractResult value
     * @throws \InvalidArgumentException
     * @param \StructType\ContractSearchDetail $item
     * @return \StructType\SearchContractListResponse
     */
    public function addToContractResult(\StructType\ContractSearchDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ContractSearchDetail) {
            throw new \InvalidArgumentException(sprintf('The contractResult property can only contain items of type \StructType\ContractSearchDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->contractResult[] = $item;
        return $this;
    }
    /**
     * Get outstandingPayment value
     * @return bool|null
     */
    public function getOutstandingPayment()
    {
        return $this->outstandingPayment;
    }
    /**
     * Set outstandingPayment value
     * @param bool $outstandingPayment
     * @return \StructType\SearchContractListResponse
     */
    public function setOutstandingPayment($outstandingPayment = null)
    {
        // validation for constraint: boolean
        if (!is_null($outstandingPayment) && !is_bool($outstandingPayment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($outstandingPayment, true), gettype($outstandingPayment)), __LINE__);
        }
        $this->outstandingPayment = $outstandingPayment;
        return $this;
    }
    /**
     * Get evpServiceFault value
     * @return \StructType\EvpServiceFault|null
     */
    public function getEvpServiceFault()
    {
        return $this->evpServiceFault;
    }
    /**
     * Set evpServiceFault value
     * @param \StructType\EvpServiceFault $evpServiceFault
     * @return \StructType\SearchContractListResponse
     */
    public function setEvpServiceFault(\StructType\EvpServiceFault $evpServiceFault = null)
    {
        $this->evpServiceFault = $evpServiceFault;
        return $this;
    }
    /**
     * Get hasCustomerAccountPayment value
     * @return bool|null
     */
    public function getHasCustomerAccountPayment()
    {
        return $this->hasCustomerAccountPayment;
    }
    /**
     * Set hasCustomerAccountPayment value
     * @param bool $hasCustomerAccountPayment
     * @return \StructType\SearchContractListResponse
     */
    public function setHasCustomerAccountPayment($hasCustomerAccountPayment = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasCustomerAccountPayment) && !is_bool($hasCustomerAccountPayment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasCustomerAccountPayment, true), gettype($hasCustomerAccountPayment)), __LINE__);
        }
        $this->hasCustomerAccountPayment = $hasCustomerAccountPayment;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SearchContractListResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
