<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for searchClaimRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Request zum Suchen von Schäden
 * @subpackage Structs
 */
class SearchClaimRequest extends AbstractStructBase
{
    /**
     * The login
     * @var \StructType\Login
     */
    public $login;
    /**
     * The claimNumber
     * Meta information extracted from the WSDL
     * - documentation: Schadensnummer
     * @var string
     */
    public $claimNumber;
    /**
     * The withoutFrame
     * Meta information extracted from the WSDL
     * - documentation: Definiert ob ein eVP Navigationsframe angezeigt wird oder nicht. Default TRUE
     * - default: false
     * - minOccurs: 0
     * @var bool
     */
    public $withoutFrame;
    /**
     * Constructor method for searchClaimRequest
     * @uses SearchClaimRequest::setLogin()
     * @uses SearchClaimRequest::setClaimNumber()
     * @uses SearchClaimRequest::setWithoutFrame()
     * @param \StructType\Login $login
     * @param string $claimNumber
     * @param bool $withoutFrame
     */
    public function __construct(\StructType\Login $login = null, $claimNumber = null, $withoutFrame = false)
    {
        $this
            ->setLogin($login)
            ->setClaimNumber($claimNumber)
            ->setWithoutFrame($withoutFrame);
    }
    /**
     * Get login value
     * @return \StructType\Login|null
     */
    public function getLogin()
    {
        return $this->login;
    }
    /**
     * Set login value
     * @param \StructType\Login $login
     * @return \StructType\SearchClaimRequest
     */
    public function setLogin(\StructType\Login $login = null)
    {
        $this->login = $login;
        return $this;
    }
    /**
     * Get claimNumber value
     * @return string|null
     */
    public function getClaimNumber()
    {
        return $this->claimNumber;
    }
    /**
     * Set claimNumber value
     * @param string $claimNumber
     * @return \StructType\SearchClaimRequest
     */
    public function setClaimNumber($claimNumber = null)
    {
        // validation for constraint: string
        if (!is_null($claimNumber) && !is_string($claimNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($claimNumber, true), gettype($claimNumber)), __LINE__);
        }
        $this->claimNumber = $claimNumber;
        return $this;
    }
    /**
     * Get withoutFrame value
     * @return bool|null
     */
    public function getWithoutFrame()
    {
        return $this->withoutFrame;
    }
    /**
     * Set withoutFrame value
     * @param bool $withoutFrame
     * @return \StructType\SearchClaimRequest
     */
    public function setWithoutFrame($withoutFrame = false)
    {
        // validation for constraint: boolean
        if (!is_null($withoutFrame) && !is_bool($withoutFrame)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($withoutFrame, true), gettype($withoutFrame)), __LINE__);
        }
        $this->withoutFrame = $withoutFrame;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SearchClaimRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
