<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for rueckmeldungType StructType
 * @subpackage Structs
 */
class RueckmeldungType extends AbstractStructBase
{
    /**
     * The tisGfNr
     * Meta information extracted from the WSDL
     * - documentation: TIS GF Nr die beim Speichern vergeben wird.
     * - minOccurs: 0
     * @var string
     */
    public $tisGfNr;
    /**
     * The polizzennummer
     * Meta information extracted from the WSDL
     * - documentation: Nach erfolgter Polizzierung wird hier nachträglich die Polizzennummer ergaenzt
     * - minOccurs: 0
     * @var string
     */
    public $polizzennummer;
    /**
     * The praemieninfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PraemieninfoType
     */
    public $praemieninfo;
    /**
     * The attachmentinfoList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AttachmentinfoList
     */
    public $attachmentinfoList;
    /**
     * Constructor method for rueckmeldungType
     * @uses RueckmeldungType::setTisGfNr()
     * @uses RueckmeldungType::setPolizzennummer()
     * @uses RueckmeldungType::setPraemieninfo()
     * @uses RueckmeldungType::setAttachmentinfoList()
     * @param string $tisGfNr
     * @param string $polizzennummer
     * @param \StructType\PraemieninfoType $praemieninfo
     * @param \StructType\AttachmentinfoList $attachmentinfoList
     */
    public function __construct($tisGfNr = null, $polizzennummer = null, \StructType\PraemieninfoType $praemieninfo = null, \StructType\AttachmentinfoList $attachmentinfoList = null)
    {
        $this
            ->setTisGfNr($tisGfNr)
            ->setPolizzennummer($polizzennummer)
            ->setPraemieninfo($praemieninfo)
            ->setAttachmentinfoList($attachmentinfoList);
    }
    /**
     * Get tisGfNr value
     * @return string|null
     */
    public function getTisGfNr()
    {
        return $this->tisGfNr;
    }
    /**
     * Set tisGfNr value
     * @param string $tisGfNr
     * @return \StructType\RueckmeldungType
     */
    public function setTisGfNr($tisGfNr = null)
    {
        // validation for constraint: string
        if (!is_null($tisGfNr) && !is_string($tisGfNr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tisGfNr, true), gettype($tisGfNr)), __LINE__);
        }
        $this->tisGfNr = $tisGfNr;
        return $this;
    }
    /**
     * Get polizzennummer value
     * @return string|null
     */
    public function getPolizzennummer()
    {
        return $this->polizzennummer;
    }
    /**
     * Set polizzennummer value
     * @param string $polizzennummer
     * @return \StructType\RueckmeldungType
     */
    public function setPolizzennummer($polizzennummer = null)
    {
        // validation for constraint: string
        if (!is_null($polizzennummer) && !is_string($polizzennummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($polizzennummer, true), gettype($polizzennummer)), __LINE__);
        }
        $this->polizzennummer = $polizzennummer;
        return $this;
    }
    /**
     * Get praemieninfo value
     * @return \StructType\PraemieninfoType|null
     */
    public function getPraemieninfo()
    {
        return $this->praemieninfo;
    }
    /**
     * Set praemieninfo value
     * @param \StructType\PraemieninfoType $praemieninfo
     * @return \StructType\RueckmeldungType
     */
    public function setPraemieninfo(\StructType\PraemieninfoType $praemieninfo = null)
    {
        $this->praemieninfo = $praemieninfo;
        return $this;
    }
    /**
     * Get attachmentinfoList value
     * @return \StructType\AttachmentinfoList|null
     */
    public function getAttachmentinfoList()
    {
        return $this->attachmentinfoList;
    }
    /**
     * Set attachmentinfoList value
     * @param \StructType\AttachmentinfoList $attachmentinfoList
     * @return \StructType\RueckmeldungType
     */
    public function setAttachmentinfoList(\StructType\AttachmentinfoList $attachmentinfoList = null)
    {
        $this->attachmentinfoList = $attachmentinfoList;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RueckmeldungType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
