<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for rsVerkehrsbereichsType StructType
 * @subpackage Structs
 */
class RsVerkehrsbereichsType extends AbstractStructBase
{
    /**
     * The schadenersatzStrafFuehrerscheinRS
     * @var string
     */
    public $schadenersatzStrafFuehrerscheinRS;
    /**
     * The fahrzeugvertragsRS
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $fahrzeugvertragsRS;
    /**
     * The lenkerVerkehrsteilnehmerRS
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $lenkerVerkehrsteilnehmerRS;
    /**
     * The versicherteFahrzeugeAuswahl
     * @var string
     */
    public $versicherteFahrzeugeAuswahl;
    /**
     * The versicherteFahrzeuge
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\VersicherteFahrzeugeType
     */
    public $versicherteFahrzeuge;
    /**
     * Constructor method for rsVerkehrsbereichsType
     * @uses RsVerkehrsbereichsType::setSchadenersatzStrafFuehrerscheinRS()
     * @uses RsVerkehrsbereichsType::setFahrzeugvertragsRS()
     * @uses RsVerkehrsbereichsType::setLenkerVerkehrsteilnehmerRS()
     * @uses RsVerkehrsbereichsType::setVersicherteFahrzeugeAuswahl()
     * @uses RsVerkehrsbereichsType::setVersicherteFahrzeuge()
     * @param string $schadenersatzStrafFuehrerscheinRS
     * @param string $fahrzeugvertragsRS
     * @param string $lenkerVerkehrsteilnehmerRS
     * @param string $versicherteFahrzeugeAuswahl
     * @param \StructType\VersicherteFahrzeugeType $versicherteFahrzeuge
     */
    public function __construct($schadenersatzStrafFuehrerscheinRS = null, $fahrzeugvertragsRS = null, $lenkerVerkehrsteilnehmerRS = null, $versicherteFahrzeugeAuswahl = null, \StructType\VersicherteFahrzeugeType $versicherteFahrzeuge = null)
    {
        $this
            ->setSchadenersatzStrafFuehrerscheinRS($schadenersatzStrafFuehrerscheinRS)
            ->setFahrzeugvertragsRS($fahrzeugvertragsRS)
            ->setLenkerVerkehrsteilnehmerRS($lenkerVerkehrsteilnehmerRS)
            ->setVersicherteFahrzeugeAuswahl($versicherteFahrzeugeAuswahl)
            ->setVersicherteFahrzeuge($versicherteFahrzeuge);
    }
    /**
     * Get schadenersatzStrafFuehrerscheinRS value
     * @return string|null
     */
    public function getSchadenersatzStrafFuehrerscheinRS()
    {
        return $this->schadenersatzStrafFuehrerscheinRS;
    }
    /**
     * Set schadenersatzStrafFuehrerscheinRS value
     * @uses \EnumType\JaNeinType::valueIsValid()
     * @uses \EnumType\JaNeinType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $schadenersatzStrafFuehrerscheinRS
     * @return \StructType\RsVerkehrsbereichsType
     */
    public function setSchadenersatzStrafFuehrerscheinRS($schadenersatzStrafFuehrerscheinRS = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JaNeinType::valueIsValid($schadenersatzStrafFuehrerscheinRS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JaNeinType', is_array($schadenersatzStrafFuehrerscheinRS) ? implode(', ', $schadenersatzStrafFuehrerscheinRS) : var_export($schadenersatzStrafFuehrerscheinRS, true), implode(', ', \EnumType\JaNeinType::getValidValues())), __LINE__);
        }
        $this->schadenersatzStrafFuehrerscheinRS = $schadenersatzStrafFuehrerscheinRS;
        return $this;
    }
    /**
     * Get fahrzeugvertragsRS value
     * @return string|null
     */
    public function getFahrzeugvertragsRS()
    {
        return $this->fahrzeugvertragsRS;
    }
    /**
     * Set fahrzeugvertragsRS value
     * @uses \EnumType\JaNeinType::valueIsValid()
     * @uses \EnumType\JaNeinType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $fahrzeugvertragsRS
     * @return \StructType\RsVerkehrsbereichsType
     */
    public function setFahrzeugvertragsRS($fahrzeugvertragsRS = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JaNeinType::valueIsValid($fahrzeugvertragsRS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JaNeinType', is_array($fahrzeugvertragsRS) ? implode(', ', $fahrzeugvertragsRS) : var_export($fahrzeugvertragsRS, true), implode(', ', \EnumType\JaNeinType::getValidValues())), __LINE__);
        }
        $this->fahrzeugvertragsRS = $fahrzeugvertragsRS;
        return $this;
    }
    /**
     * Get lenkerVerkehrsteilnehmerRS value
     * @return string|null
     */
    public function getLenkerVerkehrsteilnehmerRS()
    {
        return $this->lenkerVerkehrsteilnehmerRS;
    }
    /**
     * Set lenkerVerkehrsteilnehmerRS value
     * @uses \EnumType\JaNeinType::valueIsValid()
     * @uses \EnumType\JaNeinType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $lenkerVerkehrsteilnehmerRS
     * @return \StructType\RsVerkehrsbereichsType
     */
    public function setLenkerVerkehrsteilnehmerRS($lenkerVerkehrsteilnehmerRS = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JaNeinType::valueIsValid($lenkerVerkehrsteilnehmerRS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JaNeinType', is_array($lenkerVerkehrsteilnehmerRS) ? implode(', ', $lenkerVerkehrsteilnehmerRS) : var_export($lenkerVerkehrsteilnehmerRS, true), implode(', ', \EnumType\JaNeinType::getValidValues())), __LINE__);
        }
        $this->lenkerVerkehrsteilnehmerRS = $lenkerVerkehrsteilnehmerRS;
        return $this;
    }
    /**
     * Get versicherteFahrzeugeAuswahl value
     * @return string|null
     */
    public function getVersicherteFahrzeugeAuswahl()
    {
        return $this->versicherteFahrzeugeAuswahl;
    }
    /**
     * Set versicherteFahrzeugeAuswahl value
     * @uses \EnumType\VersicherteFahrzeugeAuswahl::valueIsValid()
     * @uses \EnumType\VersicherteFahrzeugeAuswahl::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $versicherteFahrzeugeAuswahl
     * @return \StructType\RsVerkehrsbereichsType
     */
    public function setVersicherteFahrzeugeAuswahl($versicherteFahrzeugeAuswahl = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\VersicherteFahrzeugeAuswahl::valueIsValid($versicherteFahrzeugeAuswahl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\VersicherteFahrzeugeAuswahl', is_array($versicherteFahrzeugeAuswahl) ? implode(', ', $versicherteFahrzeugeAuswahl) : var_export($versicherteFahrzeugeAuswahl, true), implode(', ', \EnumType\VersicherteFahrzeugeAuswahl::getValidValues())), __LINE__);
        }
        $this->versicherteFahrzeugeAuswahl = $versicherteFahrzeugeAuswahl;
        return $this;
    }
    /**
     * Get versicherteFahrzeuge value
     * @return \StructType\VersicherteFahrzeugeType|null
     */
    public function getVersicherteFahrzeuge()
    {
        return $this->versicherteFahrzeuge;
    }
    /**
     * Set versicherteFahrzeuge value
     * @param \StructType\VersicherteFahrzeugeType $versicherteFahrzeuge
     * @return \StructType\RsVerkehrsbereichsType
     */
    public function setVersicherteFahrzeuge(\StructType\VersicherteFahrzeugeType $versicherteFahrzeuge = null)
    {
        $this->versicherteFahrzeuge = $versicherteFahrzeuge;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RsVerkehrsbereichsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
