<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for risikoAdresseType StructType
 * @subpackage Structs
 */
class RisikoAdresseType extends AbstractStructBase
{
    /**
     * The land
     * @var string
     */
    public $land;
    /**
     * The plz
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 5
     * @var string
     */
    public $plz;
    /**
     * The ort
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 40
     * @var string
     */
    public $ort;
    /**
     * The strasse
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 40
     * @var string
     */
    public $strasse;
    /**
     * The hausnummer
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 10
     * @var string
     */
    public $hausnummer;
    /**
     * The hausnummernZusatz
     * Meta information extracted from the WSDL
     * - documentation: Stiege, Tür, Stock, Objektnummer, ....
     * - base: xs:string
     * - maxLength: 40
     * - minOccurs: 0
     * @var string
     */
    public $hausnummernZusatz;
    /**
     * The zuHandenEmpfaenger
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - choice: zuHandenEmpfaenger | coPartnerEmpfaenger
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * - maxLength: 40
     * @var string
     */
    public $zuHandenEmpfaenger;
    /**
     * The coPartnerEmpfaenger
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - choice: zuHandenEmpfaenger | coPartnerEmpfaenger
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * - maxLength: 40
     * @var string
     */
    public $coPartnerEmpfaenger;
    /**
     * The adresseKommentar
     * Meta information extracted from the WSDL
     * - documentation: Sie können hier weitere Details zur Adresse erfassen: zB Hauptadresse, Risikoadresse, …
     * - base: xs:string
     * - maxLength: 50
     * - minOccurs: 0
     * @var string
     */
    public $adresseKommentar;
    /**
     * Constructor method for risikoAdresseType
     * @uses RisikoAdresseType::setLand()
     * @uses RisikoAdresseType::setPlz()
     * @uses RisikoAdresseType::setOrt()
     * @uses RisikoAdresseType::setStrasse()
     * @uses RisikoAdresseType::setHausnummer()
     * @uses RisikoAdresseType::setHausnummernZusatz()
     * @uses RisikoAdresseType::setZuHandenEmpfaenger()
     * @uses RisikoAdresseType::setCoPartnerEmpfaenger()
     * @uses RisikoAdresseType::setAdresseKommentar()
     * @param string $land
     * @param string $plz
     * @param string $ort
     * @param string $strasse
     * @param string $hausnummer
     * @param string $hausnummernZusatz
     * @param string $zuHandenEmpfaenger
     * @param string $coPartnerEmpfaenger
     * @param string $adresseKommentar
     */
    public function __construct($land = null, $plz = null, $ort = null, $strasse = null, $hausnummer = null, $hausnummernZusatz = null, $zuHandenEmpfaenger = null, $coPartnerEmpfaenger = null, $adresseKommentar = null)
    {
        $this
            ->setLand($land)
            ->setPlz($plz)
            ->setOrt($ort)
            ->setStrasse($strasse)
            ->setHausnummer($hausnummer)
            ->setHausnummernZusatz($hausnummernZusatz)
            ->setZuHandenEmpfaenger($zuHandenEmpfaenger)
            ->setCoPartnerEmpfaenger($coPartnerEmpfaenger)
            ->setAdresseKommentar($adresseKommentar);
    }
    /**
     * Get land value
     * @return string|null
     */
    public function getLand()
    {
        return $this->land;
    }
    /**
     * Set land value
     * @uses \EnumType\LandType::valueIsValid()
     * @uses \EnumType\LandType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $land
     * @return \StructType\RisikoAdresseType
     */
    public function setLand($land = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\LandType::valueIsValid($land)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\LandType', is_array($land) ? implode(', ', $land) : var_export($land, true), implode(', ', \EnumType\LandType::getValidValues())), __LINE__);
        }
        $this->land = $land;
        return $this;
    }
    /**
     * Get plz value
     * @return string|null
     */
    public function getPlz()
    {
        return $this->plz;
    }
    /**
     * Set plz value
     * @param string $plz
     * @return \StructType\RisikoAdresseType
     */
    public function setPlz($plz = null)
    {
        // validation for constraint: string
        if (!is_null($plz) && !is_string($plz)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($plz, true), gettype($plz)), __LINE__);
        }
        // validation for constraint: maxLength(5)
        if (!is_null($plz) && mb_strlen($plz) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 5', mb_strlen($plz)), __LINE__);
        }
        $this->plz = $plz;
        return $this;
    }
    /**
     * Get ort value
     * @return string|null
     */
    public function getOrt()
    {
        return $this->ort;
    }
    /**
     * Set ort value
     * @param string $ort
     * @return \StructType\RisikoAdresseType
     */
    public function setOrt($ort = null)
    {
        // validation for constraint: string
        if (!is_null($ort) && !is_string($ort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ort, true), gettype($ort)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($ort) && mb_strlen($ort) > 40) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen($ort)), __LINE__);
        }
        $this->ort = $ort;
        return $this;
    }
    /**
     * Get strasse value
     * @return string|null
     */
    public function getStrasse()
    {
        return $this->strasse;
    }
    /**
     * Set strasse value
     * @param string $strasse
     * @return \StructType\RisikoAdresseType
     */
    public function setStrasse($strasse = null)
    {
        // validation for constraint: string
        if (!is_null($strasse) && !is_string($strasse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($strasse, true), gettype($strasse)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($strasse) && mb_strlen($strasse) > 40) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen($strasse)), __LINE__);
        }
        $this->strasse = $strasse;
        return $this;
    }
    /**
     * Get hausnummer value
     * @return string|null
     */
    public function getHausnummer()
    {
        return $this->hausnummer;
    }
    /**
     * Set hausnummer value
     * @param string $hausnummer
     * @return \StructType\RisikoAdresseType
     */
    public function setHausnummer($hausnummer = null)
    {
        // validation for constraint: string
        if (!is_null($hausnummer) && !is_string($hausnummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hausnummer, true), gettype($hausnummer)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($hausnummer) && mb_strlen($hausnummer) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($hausnummer)), __LINE__);
        }
        $this->hausnummer = $hausnummer;
        return $this;
    }
    /**
     * Get hausnummernZusatz value
     * @return string|null
     */
    public function getHausnummernZusatz()
    {
        return $this->hausnummernZusatz;
    }
    /**
     * Set hausnummernZusatz value
     * @param string $hausnummernZusatz
     * @return \StructType\RisikoAdresseType
     */
    public function setHausnummernZusatz($hausnummernZusatz = null)
    {
        // validation for constraint: string
        if (!is_null($hausnummernZusatz) && !is_string($hausnummernZusatz)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hausnummernZusatz, true), gettype($hausnummernZusatz)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($hausnummernZusatz) && mb_strlen($hausnummernZusatz) > 40) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen($hausnummernZusatz)), __LINE__);
        }
        $this->hausnummernZusatz = $hausnummernZusatz;
        return $this;
    }
    /**
     * Get zuHandenEmpfaenger value
     * @return string|null
     */
    public function getZuHandenEmpfaenger()
    {
        return isset($this->zuHandenEmpfaenger) ? $this->zuHandenEmpfaenger : null;
    }
    /**
     * This method is responsible for validating the value passed to the setZuHandenEmpfaenger method
     * This method is willingly generated in order to preserve the one-line inline validation within the setZuHandenEmpfaenger method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateZuHandenEmpfaengerForChoiceConstraintsFromSetZuHandenEmpfaenger($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'coPartnerEmpfaenger',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property zuHandenEmpfaenger can\'t be set as the property %s is already set. Only one property must be set among these properties: zuHandenEmpfaenger, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set zuHandenEmpfaenger value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $zuHandenEmpfaenger
     * @return \StructType\RisikoAdresseType
     */
    public function setZuHandenEmpfaenger($zuHandenEmpfaenger = null)
    {
        // validation for constraint: string
        if (!is_null($zuHandenEmpfaenger) && !is_string($zuHandenEmpfaenger)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zuHandenEmpfaenger, true), gettype($zuHandenEmpfaenger)), __LINE__);
        }
        // validation for constraint: choice(zuHandenEmpfaenger, coPartnerEmpfaenger)
        if ('' !== ($zuHandenEmpfaengerChoiceErrorMessage = self::validateZuHandenEmpfaengerForChoiceConstraintsFromSetZuHandenEmpfaenger($zuHandenEmpfaenger))) {
            throw new \InvalidArgumentException($zuHandenEmpfaengerChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($zuHandenEmpfaenger) && mb_strlen($zuHandenEmpfaenger) > 40) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen($zuHandenEmpfaenger)), __LINE__);
        }
        if (is_null($zuHandenEmpfaenger) || (is_array($zuHandenEmpfaenger) && empty($zuHandenEmpfaenger))) {
            unset($this->zuHandenEmpfaenger);
        } else {
            $this->zuHandenEmpfaenger = $zuHandenEmpfaenger;
        }
        return $this;
    }
    /**
     * Get coPartnerEmpfaenger value
     * @return string|null
     */
    public function getCoPartnerEmpfaenger()
    {
        return isset($this->coPartnerEmpfaenger) ? $this->coPartnerEmpfaenger : null;
    }
    /**
     * This method is responsible for validating the value passed to the setCoPartnerEmpfaenger method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCoPartnerEmpfaenger method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateCoPartnerEmpfaengerForChoiceConstraintsFromSetCoPartnerEmpfaenger($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'zuHandenEmpfaenger',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property coPartnerEmpfaenger can\'t be set as the property %s is already set. Only one property must be set among these properties: coPartnerEmpfaenger, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set coPartnerEmpfaenger value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $coPartnerEmpfaenger
     * @return \StructType\RisikoAdresseType
     */
    public function setCoPartnerEmpfaenger($coPartnerEmpfaenger = null)
    {
        // validation for constraint: string
        if (!is_null($coPartnerEmpfaenger) && !is_string($coPartnerEmpfaenger)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($coPartnerEmpfaenger, true), gettype($coPartnerEmpfaenger)), __LINE__);
        }
        // validation for constraint: choice(zuHandenEmpfaenger, coPartnerEmpfaenger)
        if ('' !== ($coPartnerEmpfaengerChoiceErrorMessage = self::validateCoPartnerEmpfaengerForChoiceConstraintsFromSetCoPartnerEmpfaenger($coPartnerEmpfaenger))) {
            throw new \InvalidArgumentException($coPartnerEmpfaengerChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($coPartnerEmpfaenger) && mb_strlen($coPartnerEmpfaenger) > 40) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen($coPartnerEmpfaenger)), __LINE__);
        }
        if (is_null($coPartnerEmpfaenger) || (is_array($coPartnerEmpfaenger) && empty($coPartnerEmpfaenger))) {
            unset($this->coPartnerEmpfaenger);
        } else {
            $this->coPartnerEmpfaenger = $coPartnerEmpfaenger;
        }
        return $this;
    }
    /**
     * Get adresseKommentar value
     * @return string|null
     */
    public function getAdresseKommentar()
    {
        return $this->adresseKommentar;
    }
    /**
     * Set adresseKommentar value
     * @param string $adresseKommentar
     * @return \StructType\RisikoAdresseType
     */
    public function setAdresseKommentar($adresseKommentar = null)
    {
        // validation for constraint: string
        if (!is_null($adresseKommentar) && !is_string($adresseKommentar)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adresseKommentar, true), gettype($adresseKommentar)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($adresseKommentar) && mb_strlen($adresseKommentar) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($adresseKommentar)), __LINE__);
        }
        $this->adresseKommentar = $adresseKommentar;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RisikoAdresseType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
