<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for resetUserPasswordQuestionAnswerRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Request zum Zurücksetzen des Benutzer Passwortes
 * @subpackage Structs
 */
class ResetUserPasswordQuestionAnswerRequest extends AbstractStructBase
{
    /**
     * The login
     * @var \StructType\Login
     */
    public $login;
    /**
     * The userID
     * @var string
     */
    public $userID;
    /**
     * Constructor method for resetUserPasswordQuestionAnswerRequest
     * @uses ResetUserPasswordQuestionAnswerRequest::setLogin()
     * @uses ResetUserPasswordQuestionAnswerRequest::setUserID()
     * @param \StructType\Login $login
     * @param string $userID
     */
    public function __construct(\StructType\Login $login = null, $userID = null)
    {
        $this
            ->setLogin($login)
            ->setUserID($userID);
    }
    /**
     * Get login value
     * @return \StructType\Login|null
     */
    public function getLogin()
    {
        return $this->login;
    }
    /**
     * Set login value
     * @param \StructType\Login $login
     * @return \StructType\ResetUserPasswordQuestionAnswerRequest
     */
    public function setLogin(\StructType\Login $login = null)
    {
        $this->login = $login;
        return $this;
    }
    /**
     * Get userID value
     * @return string|null
     */
    public function getUserID()
    {
        return $this->userID;
    }
    /**
     * Set userID value
     * @param string $userID
     * @return \StructType\ResetUserPasswordQuestionAnswerRequest
     */
    public function setUserID($userID = null)
    {
        // validation for constraint: string
        if (!is_null($userID) && !is_string($userID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userID, true), gettype($userID)), __LINE__);
        }
        $this->userID = $userID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ResetUserPasswordQuestionAnswerRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
