<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for removeCustomerResponse StructType
 * Meta information extracted from the WSDL
 * - documentation: Response zum Kunden löschen. Liefert eine Meldung ob der Kunde erfolgreich gelöscht wurde
 * @subpackage Structs
 */
class RemoveCustomerResponse extends AbstractStructBase
{
    /**
     * The customerID
     * @var int
     */
    public $customerID;
    /**
     * The evpServiceFault
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\EvpServiceFault
     */
    public $evpServiceFault;
    /**
     * Constructor method for removeCustomerResponse
     * @uses RemoveCustomerResponse::setCustomerID()
     * @uses RemoveCustomerResponse::setEvpServiceFault()
     * @param int $customerID
     * @param \StructType\EvpServiceFault $evpServiceFault
     */
    public function __construct($customerID = null, \StructType\EvpServiceFault $evpServiceFault = null)
    {
        $this
            ->setCustomerID($customerID)
            ->setEvpServiceFault($evpServiceFault);
    }
    /**
     * Get customerID value
     * @return int|null
     */
    public function getCustomerID()
    {
        return $this->customerID;
    }
    /**
     * Set customerID value
     * @param int $customerID
     * @return \StructType\RemoveCustomerResponse
     */
    public function setCustomerID($customerID = null)
    {
        // validation for constraint: int
        if (!is_null($customerID) && !(is_int($customerID) || ctype_digit($customerID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerID, true), gettype($customerID)), __LINE__);
        }
        $this->customerID = $customerID;
        return $this;
    }
    /**
     * Get evpServiceFault value
     * @return \StructType\EvpServiceFault|null
     */
    public function getEvpServiceFault()
    {
        return $this->evpServiceFault;
    }
    /**
     * Set evpServiceFault value
     * @param \StructType\EvpServiceFault $evpServiceFault
     * @return \StructType\RemoveCustomerResponse
     */
    public function setEvpServiceFault(\StructType\EvpServiceFault $evpServiceFault = null)
    {
        $this->evpServiceFault = $evpServiceFault;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RemoveCustomerResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
