<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for removeCustomerRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Request um Kunden zu löschen. Ein Löschen ist nur dann möglich, wenn der User die nötigen Berechtigungen in der eVP besitzt
 * @subpackage Structs
 */
class RemoveCustomerRequest extends AbstractStructBase
{
    /**
     * The login
     * @var \StructType\Login
     */
    public $login;
    /**
     * The customerID
     * @var int
     */
    public $customerID;
    /**
     * Constructor method for removeCustomerRequest
     * @uses RemoveCustomerRequest::setLogin()
     * @uses RemoveCustomerRequest::setCustomerID()
     * @param \StructType\Login $login
     * @param int $customerID
     */
    public function __construct(\StructType\Login $login = null, $customerID = null)
    {
        $this
            ->setLogin($login)
            ->setCustomerID($customerID);
    }
    /**
     * Get login value
     * @return \StructType\Login|null
     */
    public function getLogin()
    {
        return $this->login;
    }
    /**
     * Set login value
     * @param \StructType\Login $login
     * @return \StructType\RemoveCustomerRequest
     */
    public function setLogin(\StructType\Login $login = null)
    {
        $this->login = $login;
        return $this;
    }
    /**
     * Get customerID value
     * @return int|null
     */
    public function getCustomerID()
    {
        return $this->customerID;
    }
    /**
     * Set customerID value
     * @param int $customerID
     * @return \StructType\RemoveCustomerRequest
     */
    public function setCustomerID($customerID = null)
    {
        // validation for constraint: int
        if (!is_null($customerID) && !(is_int($customerID) || ctype_digit($customerID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerID, true), gettype($customerID)), __LINE__);
        }
        $this->customerID = $customerID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RemoveCustomerRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
