<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PolicyPartnerRole StructType
 * Meta information extracted from the WSDL
 * - documentation: Polizzenobjekt
 * @subpackage Structs
 */
class PolicyPartnerRole extends AbstractStructBase
{
    /**
     * The paOid
     * Meta information extracted from the WSDL
     * - documentation: PAOid des Kunden
     * @var string
     */
    public $paOid;
    /**
     * The partnerRoles
     * Meta information extracted from the WSDL
     * - documentation: Partnerrollen zu der Polizzennummern
     * @var int
     */
    public $partnerRoles;
    /**
     * The adrPaoid
     * Meta information extracted from the WSDL
     * - documentation: Address PAOid des Kunden
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $adrPaoid;
    /**
     * The bankPaoid
     * Meta information extracted from the WSDL
     * - documentation: Bank PAOid des Kunden
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $bankPaoid;
    /**
     * The vtVPNr
     * Meta information extracted from the WSDL
     * - documentation: für Obsorgeberechtigen-Rolle (ob VP oder VN)
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $vtVPNr;
    /**
     * Constructor method for PolicyPartnerRole
     * @uses PolicyPartnerRole::setPaOid()
     * @uses PolicyPartnerRole::setPartnerRoles()
     * @uses PolicyPartnerRole::setAdrPaoid()
     * @uses PolicyPartnerRole::setBankPaoid()
     * @uses PolicyPartnerRole::setVtVPNr()
     * @param string $paOid
     * @param int $partnerRoles
     * @param string $adrPaoid
     * @param string $bankPaoid
     * @param int $vtVPNr
     */
    public function __construct($paOid = null, $partnerRoles = null, $adrPaoid = null, $bankPaoid = null, $vtVPNr = null)
    {
        $this
            ->setPaOid($paOid)
            ->setPartnerRoles($partnerRoles)
            ->setAdrPaoid($adrPaoid)
            ->setBankPaoid($bankPaoid)
            ->setVtVPNr($vtVPNr);
    }
    /**
     * Get paOid value
     * @return string|null
     */
    public function getPaOid()
    {
        return $this->paOid;
    }
    /**
     * Set paOid value
     * @param string $paOid
     * @return \StructType\PolicyPartnerRole
     */
    public function setPaOid($paOid = null)
    {
        // validation for constraint: string
        if (!is_null($paOid) && !is_string($paOid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paOid, true), gettype($paOid)), __LINE__);
        }
        $this->paOid = $paOid;
        return $this;
    }
    /**
     * Get partnerRoles value
     * @return int|null
     */
    public function getPartnerRoles()
    {
        return $this->partnerRoles;
    }
    /**
     * Set partnerRoles value
     * @param int $partnerRoles
     * @return \StructType\PolicyPartnerRole
     */
    public function setPartnerRoles($partnerRoles = null)
    {
        // validation for constraint: int
        if (!is_null($partnerRoles) && !(is_int($partnerRoles) || ctype_digit($partnerRoles))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($partnerRoles, true), gettype($partnerRoles)), __LINE__);
        }
        $this->partnerRoles = $partnerRoles;
        return $this;
    }
    /**
     * Get adrPaoid value
     * @return string|null
     */
    public function getAdrPaoid()
    {
        return $this->adrPaoid;
    }
    /**
     * Set adrPaoid value
     * @param string $adrPaoid
     * @return \StructType\PolicyPartnerRole
     */
    public function setAdrPaoid($adrPaoid = null)
    {
        // validation for constraint: string
        if (!is_null($adrPaoid) && !is_string($adrPaoid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adrPaoid, true), gettype($adrPaoid)), __LINE__);
        }
        $this->adrPaoid = $adrPaoid;
        return $this;
    }
    /**
     * Get bankPaoid value
     * @return string|null
     */
    public function getBankPaoid()
    {
        return $this->bankPaoid;
    }
    /**
     * Set bankPaoid value
     * @param string $bankPaoid
     * @return \StructType\PolicyPartnerRole
     */
    public function setBankPaoid($bankPaoid = null)
    {
        // validation for constraint: string
        if (!is_null($bankPaoid) && !is_string($bankPaoid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankPaoid, true), gettype($bankPaoid)), __LINE__);
        }
        $this->bankPaoid = $bankPaoid;
        return $this;
    }
    /**
     * Get vtVPNr value
     * @return int|null
     */
    public function getVtVPNr()
    {
        return $this->vtVPNr;
    }
    /**
     * Set vtVPNr value
     * @param int $vtVPNr
     * @return \StructType\PolicyPartnerRole
     */
    public function setVtVPNr($vtVPNr = null)
    {
        // validation for constraint: int
        if (!is_null($vtVPNr) && !(is_int($vtVPNr) || ctype_digit($vtVPNr))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($vtVPNr, true), gettype($vtVPNr)), __LINE__);
        }
        $this->vtVPNr = $vtVPNr;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PolicyPartnerRole
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
