<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for partnerType StructType
 * @subpackage Structs
 */
class PartnerType extends AbstractStructBase
{
    /**
     * The anrede
     * @var string
     */
    public $anrede;
    /**
     * The titel
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 10
     * - minOccurs: 0
     * @var string
     */
    public $titel;
    /**
     * The freierTitel
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 30
     * - minOccurs: 0
     * @var string
     */
    public $freierTitel;
    /**
     * The juniorSenior
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $juniorSenior;
    /**
     * The nachname
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 100
     * - minLength: 3
     * @var string
     */
    public $nachname;
    /**
     * The vorname
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 30
     * - minOccurs: 0
     * @var string
     */
    public $vorname;
    /**
     * The geburtsdatum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $geburtsdatum;
    /**
     * The staatsangehoerigkeit
     * @var string
     */
    public $staatsangehoerigkeit;
    /**
     * The staatAdresse
     * @var string
     */
    public $staatAdresse;
    /**
     * The plz
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 5
     * @var string
     */
    public $plz;
    /**
     * The ort
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 40
     * @var string
     */
    public $ort;
    /**
     * The strasse
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 40
     * @var string
     */
    public $strasse;
    /**
     * The hausnummer
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 10
     * @var string
     */
    public $hausnummer;
    /**
     * The hausnummernZusatz
     * Meta information extracted from the WSDL
     * - documentation: Stiege, Tür, Stock, Objektnummer, ....
     * - base: xs:string
     * - maxLength: 40
     * - minOccurs: 0
     * @var string
     */
    public $hausnummernZusatz;
    /**
     * The adresseKommentar
     * Meta information extracted from the WSDL
     * - documentation: Sie können hier weitere Details zur Adresse erfassen: zB Hauptadresse, Risikoadresse, …
     * - base: xs:string
     * - maxLength: 50
     * - minOccurs: 0
     * @var string
     */
    public $adresseKommentar;
    /**
     * The kommunikation
     * Meta information extracted from the WSDL
     * - maxOccurs: 3
     * - minOccurs: 0
     * @var \StructType\KommunikationType[]
     */
    public $kommunikation;
    /**
     * Constructor method for partnerType
     * @uses PartnerType::setAnrede()
     * @uses PartnerType::setTitel()
     * @uses PartnerType::setFreierTitel()
     * @uses PartnerType::setJuniorSenior()
     * @uses PartnerType::setNachname()
     * @uses PartnerType::setVorname()
     * @uses PartnerType::setGeburtsdatum()
     * @uses PartnerType::setStaatsangehoerigkeit()
     * @uses PartnerType::setStaatAdresse()
     * @uses PartnerType::setPlz()
     * @uses PartnerType::setOrt()
     * @uses PartnerType::setStrasse()
     * @uses PartnerType::setHausnummer()
     * @uses PartnerType::setHausnummernZusatz()
     * @uses PartnerType::setAdresseKommentar()
     * @uses PartnerType::setKommunikation()
     * @param string $anrede
     * @param string $titel
     * @param string $freierTitel
     * @param string $juniorSenior
     * @param string $nachname
     * @param string $vorname
     * @param string $geburtsdatum
     * @param string $staatsangehoerigkeit
     * @param string $staatAdresse
     * @param string $plz
     * @param string $ort
     * @param string $strasse
     * @param string $hausnummer
     * @param string $hausnummernZusatz
     * @param string $adresseKommentar
     * @param \StructType\KommunikationType[] $kommunikation
     */
    public function __construct($anrede = null, $titel = null, $freierTitel = null, $juniorSenior = null, $nachname = null, $vorname = null, $geburtsdatum = null, $staatsangehoerigkeit = null, $staatAdresse = null, $plz = null, $ort = null, $strasse = null, $hausnummer = null, $hausnummernZusatz = null, $adresseKommentar = null, array $kommunikation = array())
    {
        $this
            ->setAnrede($anrede)
            ->setTitel($titel)
            ->setFreierTitel($freierTitel)
            ->setJuniorSenior($juniorSenior)
            ->setNachname($nachname)
            ->setVorname($vorname)
            ->setGeburtsdatum($geburtsdatum)
            ->setStaatsangehoerigkeit($staatsangehoerigkeit)
            ->setStaatAdresse($staatAdresse)
            ->setPlz($plz)
            ->setOrt($ort)
            ->setStrasse($strasse)
            ->setHausnummer($hausnummer)
            ->setHausnummernZusatz($hausnummernZusatz)
            ->setAdresseKommentar($adresseKommentar)
            ->setKommunikation($kommunikation);
    }
    /**
     * Get anrede value
     * @return string|null
     */
    public function getAnrede()
    {
        return $this->anrede;
    }
    /**
     * Set anrede value
     * @uses \EnumType\AnredeType::valueIsValid()
     * @uses \EnumType\AnredeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $anrede
     * @return \StructType\PartnerType
     */
    public function setAnrede($anrede = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AnredeType::valueIsValid($anrede)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AnredeType', is_array($anrede) ? implode(', ', $anrede) : var_export($anrede, true), implode(', ', \EnumType\AnredeType::getValidValues())), __LINE__);
        }
        $this->anrede = $anrede;
        return $this;
    }
    /**
     * Get titel value
     * @return string|null
     */
    public function getTitel()
    {
        return $this->titel;
    }
    /**
     * Set titel value
     * @param string $titel
     * @return \StructType\PartnerType
     */
    public function setTitel($titel = null)
    {
        // validation for constraint: string
        if (!is_null($titel) && !is_string($titel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($titel, true), gettype($titel)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($titel) && mb_strlen($titel) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($titel)), __LINE__);
        }
        $this->titel = $titel;
        return $this;
    }
    /**
     * Get freierTitel value
     * @return string|null
     */
    public function getFreierTitel()
    {
        return $this->freierTitel;
    }
    /**
     * Set freierTitel value
     * @param string $freierTitel
     * @return \StructType\PartnerType
     */
    public function setFreierTitel($freierTitel = null)
    {
        // validation for constraint: string
        if (!is_null($freierTitel) && !is_string($freierTitel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($freierTitel, true), gettype($freierTitel)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($freierTitel) && mb_strlen($freierTitel) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($freierTitel)), __LINE__);
        }
        $this->freierTitel = $freierTitel;
        return $this;
    }
    /**
     * Get juniorSenior value
     * @return string|null
     */
    public function getJuniorSenior()
    {
        return $this->juniorSenior;
    }
    /**
     * Set juniorSenior value
     * @uses \EnumType\JuniorSeniorType::valueIsValid()
     * @uses \EnumType\JuniorSeniorType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $juniorSenior
     * @return \StructType\PartnerType
     */
    public function setJuniorSenior($juniorSenior = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JuniorSeniorType::valueIsValid($juniorSenior)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JuniorSeniorType', is_array($juniorSenior) ? implode(', ', $juniorSenior) : var_export($juniorSenior, true), implode(', ', \EnumType\JuniorSeniorType::getValidValues())), __LINE__);
        }
        $this->juniorSenior = $juniorSenior;
        return $this;
    }
    /**
     * Get nachname value
     * @return string|null
     */
    public function getNachname()
    {
        return $this->nachname;
    }
    /**
     * Set nachname value
     * @param string $nachname
     * @return \StructType\PartnerType
     */
    public function setNachname($nachname = null)
    {
        // validation for constraint: string
        if (!is_null($nachname) && !is_string($nachname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nachname, true), gettype($nachname)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($nachname) && mb_strlen($nachname) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($nachname)), __LINE__);
        }
        // validation for constraint: minLength(3)
        if (!is_null($nachname) && mb_strlen($nachname) < 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 3', mb_strlen($nachname)), __LINE__);
        }
        $this->nachname = $nachname;
        return $this;
    }
    /**
     * Get vorname value
     * @return string|null
     */
    public function getVorname()
    {
        return $this->vorname;
    }
    /**
     * Set vorname value
     * @param string $vorname
     * @return \StructType\PartnerType
     */
    public function setVorname($vorname = null)
    {
        // validation for constraint: string
        if (!is_null($vorname) && !is_string($vorname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vorname, true), gettype($vorname)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($vorname) && mb_strlen($vorname) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($vorname)), __LINE__);
        }
        $this->vorname = $vorname;
        return $this;
    }
    /**
     * Get geburtsdatum value
     * @return string|null
     */
    public function getGeburtsdatum()
    {
        return $this->geburtsdatum;
    }
    /**
     * Set geburtsdatum value
     * @param string $geburtsdatum
     * @return \StructType\PartnerType
     */
    public function setGeburtsdatum($geburtsdatum = null)
    {
        // validation for constraint: string
        if (!is_null($geburtsdatum) && !is_string($geburtsdatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($geburtsdatum, true), gettype($geburtsdatum)), __LINE__);
        }
        $this->geburtsdatum = $geburtsdatum;
        return $this;
    }
    /**
     * Get staatsangehoerigkeit value
     * @return string|null
     */
    public function getStaatsangehoerigkeit()
    {
        return $this->staatsangehoerigkeit;
    }
    /**
     * Set staatsangehoerigkeit value
     * @uses \EnumType\LandType::valueIsValid()
     * @uses \EnumType\LandType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $staatsangehoerigkeit
     * @return \StructType\PartnerType
     */
    public function setStaatsangehoerigkeit($staatsangehoerigkeit = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\LandType::valueIsValid($staatsangehoerigkeit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\LandType', is_array($staatsangehoerigkeit) ? implode(', ', $staatsangehoerigkeit) : var_export($staatsangehoerigkeit, true), implode(', ', \EnumType\LandType::getValidValues())), __LINE__);
        }
        $this->staatsangehoerigkeit = $staatsangehoerigkeit;
        return $this;
    }
    /**
     * Get staatAdresse value
     * @return string|null
     */
    public function getStaatAdresse()
    {
        return $this->staatAdresse;
    }
    /**
     * Set staatAdresse value
     * @uses \EnumType\LandType::valueIsValid()
     * @uses \EnumType\LandType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $staatAdresse
     * @return \StructType\PartnerType
     */
    public function setStaatAdresse($staatAdresse = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\LandType::valueIsValid($staatAdresse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\LandType', is_array($staatAdresse) ? implode(', ', $staatAdresse) : var_export($staatAdresse, true), implode(', ', \EnumType\LandType::getValidValues())), __LINE__);
        }
        $this->staatAdresse = $staatAdresse;
        return $this;
    }
    /**
     * Get plz value
     * @return string|null
     */
    public function getPlz()
    {
        return $this->plz;
    }
    /**
     * Set plz value
     * @param string $plz
     * @return \StructType\PartnerType
     */
    public function setPlz($plz = null)
    {
        // validation for constraint: string
        if (!is_null($plz) && !is_string($plz)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($plz, true), gettype($plz)), __LINE__);
        }
        // validation for constraint: maxLength(5)
        if (!is_null($plz) && mb_strlen($plz) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 5', mb_strlen($plz)), __LINE__);
        }
        $this->plz = $plz;
        return $this;
    }
    /**
     * Get ort value
     * @return string|null
     */
    public function getOrt()
    {
        return $this->ort;
    }
    /**
     * Set ort value
     * @param string $ort
     * @return \StructType\PartnerType
     */
    public function setOrt($ort = null)
    {
        // validation for constraint: string
        if (!is_null($ort) && !is_string($ort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ort, true), gettype($ort)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($ort) && mb_strlen($ort) > 40) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen($ort)), __LINE__);
        }
        $this->ort = $ort;
        return $this;
    }
    /**
     * Get strasse value
     * @return string|null
     */
    public function getStrasse()
    {
        return $this->strasse;
    }
    /**
     * Set strasse value
     * @param string $strasse
     * @return \StructType\PartnerType
     */
    public function setStrasse($strasse = null)
    {
        // validation for constraint: string
        if (!is_null($strasse) && !is_string($strasse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($strasse, true), gettype($strasse)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($strasse) && mb_strlen($strasse) > 40) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen($strasse)), __LINE__);
        }
        $this->strasse = $strasse;
        return $this;
    }
    /**
     * Get hausnummer value
     * @return string|null
     */
    public function getHausnummer()
    {
        return $this->hausnummer;
    }
    /**
     * Set hausnummer value
     * @param string $hausnummer
     * @return \StructType\PartnerType
     */
    public function setHausnummer($hausnummer = null)
    {
        // validation for constraint: string
        if (!is_null($hausnummer) && !is_string($hausnummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hausnummer, true), gettype($hausnummer)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($hausnummer) && mb_strlen($hausnummer) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($hausnummer)), __LINE__);
        }
        $this->hausnummer = $hausnummer;
        return $this;
    }
    /**
     * Get hausnummernZusatz value
     * @return string|null
     */
    public function getHausnummernZusatz()
    {
        return $this->hausnummernZusatz;
    }
    /**
     * Set hausnummernZusatz value
     * @param string $hausnummernZusatz
     * @return \StructType\PartnerType
     */
    public function setHausnummernZusatz($hausnummernZusatz = null)
    {
        // validation for constraint: string
        if (!is_null($hausnummernZusatz) && !is_string($hausnummernZusatz)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hausnummernZusatz, true), gettype($hausnummernZusatz)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($hausnummernZusatz) && mb_strlen($hausnummernZusatz) > 40) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen($hausnummernZusatz)), __LINE__);
        }
        $this->hausnummernZusatz = $hausnummernZusatz;
        return $this;
    }
    /**
     * Get adresseKommentar value
     * @return string|null
     */
    public function getAdresseKommentar()
    {
        return $this->adresseKommentar;
    }
    /**
     * Set adresseKommentar value
     * @param string $adresseKommentar
     * @return \StructType\PartnerType
     */
    public function setAdresseKommentar($adresseKommentar = null)
    {
        // validation for constraint: string
        if (!is_null($adresseKommentar) && !is_string($adresseKommentar)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adresseKommentar, true), gettype($adresseKommentar)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($adresseKommentar) && mb_strlen($adresseKommentar) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($adresseKommentar)), __LINE__);
        }
        $this->adresseKommentar = $adresseKommentar;
        return $this;
    }
    /**
     * Get kommunikation value
     * @return \StructType\KommunikationType[]|null
     */
    public function getKommunikation()
    {
        return $this->kommunikation;
    }
    /**
     * This method is responsible for validating the values passed to the setKommunikation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setKommunikation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateKommunikationForArrayConstraintsFromSetKommunikation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $partnerTypeKommunikationItem) {
            // validation for constraint: itemType
            if (!$partnerTypeKommunikationItem instanceof \StructType\KommunikationType) {
                $invalidValues[] = is_object($partnerTypeKommunikationItem) ? get_class($partnerTypeKommunikationItem) : sprintf('%s(%s)', gettype($partnerTypeKommunikationItem), var_export($partnerTypeKommunikationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The kommunikation property can only contain items of type \StructType\KommunikationType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set kommunikation value
     * @throws \InvalidArgumentException
     * @param \StructType\KommunikationType[] $kommunikation
     * @return \StructType\PartnerType
     */
    public function setKommunikation(array $kommunikation = array())
    {
        // validation for constraint: array
        if ('' !== ($kommunikationArrayErrorMessage = self::validateKommunikationForArrayConstraintsFromSetKommunikation($kommunikation))) {
            throw new \InvalidArgumentException($kommunikationArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($kommunikation) && count($kommunikation) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 3', count($kommunikation)), __LINE__);
        }
        $this->kommunikation = $kommunikation;
        return $this;
    }
    /**
     * Add item to kommunikation value
     * @throws \InvalidArgumentException
     * @param \StructType\KommunikationType $item
     * @return \StructType\PartnerType
     */
    public function addToKommunikation(\StructType\KommunikationType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\KommunikationType) {
            throw new \InvalidArgumentException(sprintf('The kommunikation property can only contain items of type \StructType\KommunikationType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($this->kommunikation) && count($this->kommunikation) >= 3) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 3', count($this->kommunikation)), __LINE__);
        }
        $this->kommunikation[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PartnerType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
