<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for newBusinessCaseToPolicyRequest StructType
 * @subpackage Structs
 */
class NewBusinessCaseToPolicyRequest extends AbstractStructBase
{
    /**
     * The login
     * @var \StructType\Login
     */
    public $login;
    /**
     * The customer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Customer
     */
    public $customer;
    /**
     * The partnerRoles
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PartnerRoles
     */
    public $partnerRoles;
    /**
     * The dataForPolicy
     * @var \StructType\DataForPolicy
     */
    public $dataForPolicy;
    /**
     * The frameAgreementNr
     * Meta information extracted from the WSDL
     * - documentation: Makler-Rahmenvereinbarungsnummer
     * - minOccurs: 0
     * @var string
     */
    public $frameAgreementNr;
    /**
     * Constructor method for newBusinessCaseToPolicyRequest
     * @uses NewBusinessCaseToPolicyRequest::setLogin()
     * @uses NewBusinessCaseToPolicyRequest::setCustomer()
     * @uses NewBusinessCaseToPolicyRequest::setPartnerRoles()
     * @uses NewBusinessCaseToPolicyRequest::setDataForPolicy()
     * @uses NewBusinessCaseToPolicyRequest::setFrameAgreementNr()
     * @param \StructType\Login $login
     * @param \StructType\Customer $customer
     * @param \StructType\PartnerRoles $partnerRoles
     * @param \StructType\DataForPolicy $dataForPolicy
     * @param string $frameAgreementNr
     */
    public function __construct(\StructType\Login $login = null, \StructType\Customer $customer = null, \StructType\PartnerRoles $partnerRoles = null, \StructType\DataForPolicy $dataForPolicy = null, $frameAgreementNr = null)
    {
        $this
            ->setLogin($login)
            ->setCustomer($customer)
            ->setPartnerRoles($partnerRoles)
            ->setDataForPolicy($dataForPolicy)
            ->setFrameAgreementNr($frameAgreementNr);
    }
    /**
     * Get login value
     * @return \StructType\Login|null
     */
    public function getLogin()
    {
        return $this->login;
    }
    /**
     * Set login value
     * @param \StructType\Login $login
     * @return \StructType\NewBusinessCaseToPolicyRequest
     */
    public function setLogin(\StructType\Login $login = null)
    {
        $this->login = $login;
        return $this;
    }
    /**
     * Get customer value
     * @return \StructType\Customer|null
     */
    public function getCustomer()
    {
        return $this->customer;
    }
    /**
     * Set customer value
     * @param \StructType\Customer $customer
     * @return \StructType\NewBusinessCaseToPolicyRequest
     */
    public function setCustomer(\StructType\Customer $customer = null)
    {
        $this->customer = $customer;
        return $this;
    }
    /**
     * Get partnerRoles value
     * @return \StructType\PartnerRoles|null
     */
    public function getPartnerRoles()
    {
        return $this->partnerRoles;
    }
    /**
     * Set partnerRoles value
     * @param \StructType\PartnerRoles $partnerRoles
     * @return \StructType\NewBusinessCaseToPolicyRequest
     */
    public function setPartnerRoles(\StructType\PartnerRoles $partnerRoles = null)
    {
        $this->partnerRoles = $partnerRoles;
        return $this;
    }
    /**
     * Get dataForPolicy value
     * @return \StructType\DataForPolicy|null
     */
    public function getDataForPolicy()
    {
        return $this->dataForPolicy;
    }
    /**
     * Set dataForPolicy value
     * @param \StructType\DataForPolicy $dataForPolicy
     * @return \StructType\NewBusinessCaseToPolicyRequest
     */
    public function setDataForPolicy(\StructType\DataForPolicy $dataForPolicy = null)
    {
        $this->dataForPolicy = $dataForPolicy;
        return $this;
    }
    /**
     * Get frameAgreementNr value
     * @return string|null
     */
    public function getFrameAgreementNr()
    {
        return $this->frameAgreementNr;
    }
    /**
     * Set frameAgreementNr value
     * @param string $frameAgreementNr
     * @return \StructType\NewBusinessCaseToPolicyRequest
     */
    public function setFrameAgreementNr($frameAgreementNr = null)
    {
        // validation for constraint: string
        if (!is_null($frameAgreementNr) && !is_string($frameAgreementNr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($frameAgreementNr, true), gettype($frameAgreementNr)), __LINE__);
        }
        $this->frameAgreementNr = $frameAgreementNr;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\NewBusinessCaseToPolicyRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
