<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for newBusinessCasePrefilledRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Request for start a new consultation, which can be prefilled by a dynamical list of key value pairs. (Generali internal use only!)
 * @subpackage Structs
 */
class NewBusinessCasePrefilledRequest extends AbstractStructBase
{
    /**
     * The login
     * Meta information extracted from the WSDL
     * - documentation: login user
     * @var \StructType\Login
     */
    public $login;
    /**
     * The inputValues
     * Meta information extracted from the WSDL
     * - documentation: list of input parameters which will be mapped to the model (BusinessObject / VPMS)
     * - maxOccurs: 5000
     * @var \StructType\KeyValuePair[]
     */
    public $inputValues;
    /**
     * The businessCaseType
     * @var string
     */
    public $businessCaseType;
    /**
     * The customer
     * Meta information extracted from the WSDL
     * - documentation: customer eVP-ID´s
     * - maxOccurs: 50
     * - minOccurs: 0
     * @var int[]
     */
    public $customer;
    /**
     * The paCustomer
     * Meta information extracted from the WSDL
     * - documentation: PA-customers
     * - maxOccurs: 50
     * - minOccurs: 0
     * @var \StructType\PaCustomer[]
     */
    public $paCustomer;
    /**
     * The externalContractNumber
     * Meta information extracted from the WSDL
     * - documentation: Externe Antragsnummer, welche zu dem Geschäftsfall gespeichert werden.
     * - minOccurs: 0
     * @var string
     */
    public $externalContractNumber;
    /**
     * The cooperationContractNumber
     * Meta information extracted from the WSDL
     * - documentation: Polizzennummer des Kooperationsvertrags, dessen Versicherungsnehmer für die vorbefüllte Beratung herangezogen werden soll
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $cooperationContractNumber;
    /**
     * The attachment
     * Meta information extracted from the WSDL
     * - documentation: Attachment Objekte
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Attachment[]
     */
    public $attachment;
    /**
     * The withoutFrame
     * Meta information extracted from the WSDL
     * - documentation: Definiert ob ein eVP Navigationsframe angezeigt wird oder nicht
     * - default: false
     * - minOccurs: 0
     * @var bool
     */
    public $withoutFrame;
    /**
     * Constructor method for newBusinessCasePrefilledRequest
     * @uses NewBusinessCasePrefilledRequest::setLogin()
     * @uses NewBusinessCasePrefilledRequest::setInputValues()
     * @uses NewBusinessCasePrefilledRequest::setBusinessCaseType()
     * @uses NewBusinessCasePrefilledRequest::setCustomer()
     * @uses NewBusinessCasePrefilledRequest::setPaCustomer()
     * @uses NewBusinessCasePrefilledRequest::setExternalContractNumber()
     * @uses NewBusinessCasePrefilledRequest::setCooperationContractNumber()
     * @uses NewBusinessCasePrefilledRequest::setAttachment()
     * @uses NewBusinessCasePrefilledRequest::setWithoutFrame()
     * @param \StructType\Login $login
     * @param \StructType\KeyValuePair[] $inputValues
     * @param string $businessCaseType
     * @param int[] $customer
     * @param \StructType\PaCustomer[] $paCustomer
     * @param string $externalContractNumber
     * @param string $cooperationContractNumber
     * @param \StructType\Attachment[] $attachment
     * @param bool $withoutFrame
     */
    public function __construct(\StructType\Login $login = null, array $inputValues = array(), $businessCaseType = null, array $customer = array(), array $paCustomer = array(), $externalContractNumber = null, $cooperationContractNumber = null, array $attachment = array(), $withoutFrame = false)
    {
        $this
            ->setLogin($login)
            ->setInputValues($inputValues)
            ->setBusinessCaseType($businessCaseType)
            ->setCustomer($customer)
            ->setPaCustomer($paCustomer)
            ->setExternalContractNumber($externalContractNumber)
            ->setCooperationContractNumber($cooperationContractNumber)
            ->setAttachment($attachment)
            ->setWithoutFrame($withoutFrame);
    }
    /**
     * Get login value
     * @return \StructType\Login|null
     */
    public function getLogin()
    {
        return $this->login;
    }
    /**
     * Set login value
     * @param \StructType\Login $login
     * @return \StructType\NewBusinessCasePrefilledRequest
     */
    public function setLogin(\StructType\Login $login = null)
    {
        $this->login = $login;
        return $this;
    }
    /**
     * Get inputValues value
     * @return \StructType\KeyValuePair[]|null
     */
    public function getInputValues()
    {
        return $this->inputValues;
    }
    /**
     * This method is responsible for validating the values passed to the setInputValues method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInputValues method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInputValuesForArrayConstraintsFromSetInputValues(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $newBusinessCasePrefilledRequestInputValuesItem) {
            // validation for constraint: itemType
            if (!$newBusinessCasePrefilledRequestInputValuesItem instanceof \StructType\KeyValuePair) {
                $invalidValues[] = is_object($newBusinessCasePrefilledRequestInputValuesItem) ? get_class($newBusinessCasePrefilledRequestInputValuesItem) : sprintf('%s(%s)', gettype($newBusinessCasePrefilledRequestInputValuesItem), var_export($newBusinessCasePrefilledRequestInputValuesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The inputValues property can only contain items of type \StructType\KeyValuePair, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set inputValues value
     * @throws \InvalidArgumentException
     * @param \StructType\KeyValuePair[] $inputValues
     * @return \StructType\NewBusinessCasePrefilledRequest
     */
    public function setInputValues(array $inputValues = array())
    {
        // validation for constraint: array
        if ('' !== ($inputValuesArrayErrorMessage = self::validateInputValuesForArrayConstraintsFromSetInputValues($inputValues))) {
            throw new \InvalidArgumentException($inputValuesArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5000)
        if (is_array($inputValues) && count($inputValues) > 5000) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5000', count($inputValues)), __LINE__);
        }
        $this->inputValues = $inputValues;
        return $this;
    }
    /**
     * Add item to inputValues value
     * @throws \InvalidArgumentException
     * @param \StructType\KeyValuePair $item
     * @return \StructType\NewBusinessCasePrefilledRequest
     */
    public function addToInputValues(\StructType\KeyValuePair $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\KeyValuePair) {
            throw new \InvalidArgumentException(sprintf('The inputValues property can only contain items of type \StructType\KeyValuePair, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5000)
        if (is_array($this->inputValues) && count($this->inputValues) >= 5000) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5000', count($this->inputValues)), __LINE__);
        }
        $this->inputValues[] = $item;
        return $this;
    }
    /**
     * Get businessCaseType value
     * @return string|null
     */
    public function getBusinessCaseType()
    {
        return $this->businessCaseType;
    }
    /**
     * Set businessCaseType value
     * @uses \EnumType\BusinessCaseType::valueIsValid()
     * @uses \EnumType\BusinessCaseType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $businessCaseType
     * @return \StructType\NewBusinessCasePrefilledRequest
     */
    public function setBusinessCaseType($businessCaseType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\BusinessCaseType::valueIsValid($businessCaseType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\BusinessCaseType', is_array($businessCaseType) ? implode(', ', $businessCaseType) : var_export($businessCaseType, true), implode(', ', \EnumType\BusinessCaseType::getValidValues())), __LINE__);
        }
        $this->businessCaseType = $businessCaseType;
        return $this;
    }
    /**
     * Get customer value
     * @return int[]|null
     */
    public function getCustomer()
    {
        return $this->customer;
    }
    /**
     * This method is responsible for validating the values passed to the setCustomer method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustomer method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustomerForArrayConstraintsFromSetCustomer(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $newBusinessCasePrefilledRequestCustomerItem) {
            // validation for constraint: itemType
            if (!(is_int($newBusinessCasePrefilledRequestCustomerItem) || ctype_digit($newBusinessCasePrefilledRequestCustomerItem))) {
                $invalidValues[] = is_object($newBusinessCasePrefilledRequestCustomerItem) ? get_class($newBusinessCasePrefilledRequestCustomerItem) : sprintf('%s(%s)', gettype($newBusinessCasePrefilledRequestCustomerItem), var_export($newBusinessCasePrefilledRequestCustomerItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The customer property can only contain items of type integer, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set customer value
     * @throws \InvalidArgumentException
     * @param int[] $customer
     * @return \StructType\NewBusinessCasePrefilledRequest
     */
    public function setCustomer(array $customer = array())
    {
        // validation for constraint: array
        if ('' !== ($customerArrayErrorMessage = self::validateCustomerForArrayConstraintsFromSetCustomer($customer))) {
            throw new \InvalidArgumentException($customerArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(50)
        if (is_array($customer) && count($customer) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 50', count($customer)), __LINE__);
        }
        $this->customer = $customer;
        return $this;
    }
    /**
     * Add item to customer value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \StructType\NewBusinessCasePrefilledRequest
     */
    public function addToCustomer($item)
    {
        // validation for constraint: itemType
        if (!(is_int($item) || ctype_digit($item))) {
            throw new \InvalidArgumentException(sprintf('The customer property can only contain items of type integer, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(50)
        if (is_array($this->customer) && count($this->customer) >= 50) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 50', count($this->customer)), __LINE__);
        }
        $this->customer[] = $item;
        return $this;
    }
    /**
     * Get paCustomer value
     * @return \StructType\PaCustomer[]|null
     */
    public function getPaCustomer()
    {
        return $this->paCustomer;
    }
    /**
     * This method is responsible for validating the values passed to the setPaCustomer method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaCustomer method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaCustomerForArrayConstraintsFromSetPaCustomer(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $newBusinessCasePrefilledRequestPaCustomerItem) {
            // validation for constraint: itemType
            if (!$newBusinessCasePrefilledRequestPaCustomerItem instanceof \StructType\PaCustomer) {
                $invalidValues[] = is_object($newBusinessCasePrefilledRequestPaCustomerItem) ? get_class($newBusinessCasePrefilledRequestPaCustomerItem) : sprintf('%s(%s)', gettype($newBusinessCasePrefilledRequestPaCustomerItem), var_export($newBusinessCasePrefilledRequestPaCustomerItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The paCustomer property can only contain items of type \StructType\PaCustomer, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set paCustomer value
     * @throws \InvalidArgumentException
     * @param \StructType\PaCustomer[] $paCustomer
     * @return \StructType\NewBusinessCasePrefilledRequest
     */
    public function setPaCustomer(array $paCustomer = array())
    {
        // validation for constraint: array
        if ('' !== ($paCustomerArrayErrorMessage = self::validatePaCustomerForArrayConstraintsFromSetPaCustomer($paCustomer))) {
            throw new \InvalidArgumentException($paCustomerArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(50)
        if (is_array($paCustomer) && count($paCustomer) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 50', count($paCustomer)), __LINE__);
        }
        $this->paCustomer = $paCustomer;
        return $this;
    }
    /**
     * Add item to paCustomer value
     * @throws \InvalidArgumentException
     * @param \StructType\PaCustomer $item
     * @return \StructType\NewBusinessCasePrefilledRequest
     */
    public function addToPaCustomer(\StructType\PaCustomer $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PaCustomer) {
            throw new \InvalidArgumentException(sprintf('The paCustomer property can only contain items of type \StructType\PaCustomer, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(50)
        if (is_array($this->paCustomer) && count($this->paCustomer) >= 50) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 50', count($this->paCustomer)), __LINE__);
        }
        $this->paCustomer[] = $item;
        return $this;
    }
    /**
     * Get externalContractNumber value
     * @return string|null
     */
    public function getExternalContractNumber()
    {
        return $this->externalContractNumber;
    }
    /**
     * Set externalContractNumber value
     * @param string $externalContractNumber
     * @return \StructType\NewBusinessCasePrefilledRequest
     */
    public function setExternalContractNumber($externalContractNumber = null)
    {
        // validation for constraint: string
        if (!is_null($externalContractNumber) && !is_string($externalContractNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalContractNumber, true), gettype($externalContractNumber)), __LINE__);
        }
        $this->externalContractNumber = $externalContractNumber;
        return $this;
    }
    /**
     * Get cooperationContractNumber value
     * @return string|null
     */
    public function getCooperationContractNumber()
    {
        return $this->cooperationContractNumber;
    }
    /**
     * Set cooperationContractNumber value
     * @param string $cooperationContractNumber
     * @return \StructType\NewBusinessCasePrefilledRequest
     */
    public function setCooperationContractNumber($cooperationContractNumber = null)
    {
        // validation for constraint: string
        if (!is_null($cooperationContractNumber) && !is_string($cooperationContractNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cooperationContractNumber, true), gettype($cooperationContractNumber)), __LINE__);
        }
        $this->cooperationContractNumber = $cooperationContractNumber;
        return $this;
    }
    /**
     * Get attachment value
     * @return \StructType\Attachment[]|null
     */
    public function getAttachment()
    {
        return $this->attachment;
    }
    /**
     * This method is responsible for validating the values passed to the setAttachment method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAttachment method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAttachmentForArrayConstraintsFromSetAttachment(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $newBusinessCasePrefilledRequestAttachmentItem) {
            // validation for constraint: itemType
            if (!$newBusinessCasePrefilledRequestAttachmentItem instanceof \StructType\Attachment) {
                $invalidValues[] = is_object($newBusinessCasePrefilledRequestAttachmentItem) ? get_class($newBusinessCasePrefilledRequestAttachmentItem) : sprintf('%s(%s)', gettype($newBusinessCasePrefilledRequestAttachmentItem), var_export($newBusinessCasePrefilledRequestAttachmentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The attachment property can only contain items of type \StructType\Attachment, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set attachment value
     * @throws \InvalidArgumentException
     * @param \StructType\Attachment[] $attachment
     * @return \StructType\NewBusinessCasePrefilledRequest
     */
    public function setAttachment(array $attachment = array())
    {
        // validation for constraint: array
        if ('' !== ($attachmentArrayErrorMessage = self::validateAttachmentForArrayConstraintsFromSetAttachment($attachment))) {
            throw new \InvalidArgumentException($attachmentArrayErrorMessage, __LINE__);
        }
        $this->attachment = $attachment;
        return $this;
    }
    /**
     * Add item to attachment value
     * @throws \InvalidArgumentException
     * @param \StructType\Attachment $item
     * @return \StructType\NewBusinessCasePrefilledRequest
     */
    public function addToAttachment(\StructType\Attachment $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Attachment) {
            throw new \InvalidArgumentException(sprintf('The attachment property can only contain items of type \StructType\Attachment, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->attachment[] = $item;
        return $this;
    }
    /**
     * Get withoutFrame value
     * @return bool|null
     */
    public function getWithoutFrame()
    {
        return $this->withoutFrame;
    }
    /**
     * Set withoutFrame value
     * @param bool $withoutFrame
     * @return \StructType\NewBusinessCasePrefilledRequest
     */
    public function setWithoutFrame($withoutFrame = false)
    {
        // validation for constraint: boolean
        if (!is_null($withoutFrame) && !is_bool($withoutFrame)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($withoutFrame, true), gettype($withoutFrame)), __LINE__);
        }
        $this->withoutFrame = $withoutFrame;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\NewBusinessCasePrefilledRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
