<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Login StructType
 * Meta information extracted from the WSDL
 * - documentation: Login-Objekt dass bei jedem Request an die eVP mitgeschickt werden muss
 * @subpackage Structs
 */
class Login extends AbstractStructBase
{
    /**
     * The userID
     * Meta information extracted from the WSDL
     * - documentation: userID mit der sich der User (Makler) in der eVP Online anmeldet | benutzer ID
     * - base: xsd:string
     * - maxLength: 50
     * - minLength: 5
     * @var string
     */
    public $userID;
    /**
     * The userPassword
     * Meta information extracted from the WSDL
     * - documentation: Passwort zur userID mit der sich der User (Makler) in der eVP Online anmeldet
     * - base: xsd:string
     * - maxLength: 30
     * - minLength: 5
     * @var string
     */
    public $userPassword;
    /**
     * The clientID
     * Meta information extracted from the WSDL
     * - documentation: Eine ID, die einen Softwarehersteller eindeutig identifiziert.
     * - base: xsd:integer
     * @var int
     */
    public $clientID;
    /**
     * The accessToken
     * Meta information extracted from the WSDL
     * - documentation: Access Token bei Verwendung von SSO
     * - minOccurs: 0
     * @var string
     */
    public $accessToken;
    /**
     * Constructor method for Login
     * @uses Login::setUserID()
     * @uses Login::setUserPassword()
     * @uses Login::setClientID()
     * @uses Login::setAccessToken()
     * @param string $userID
     * @param string $userPassword
     * @param int $clientID
     * @param string $accessToken
     */
    public function __construct($userID = null, $userPassword = null, $clientID = null, $accessToken = null)
    {
        $this
            ->setUserID($userID)
            ->setUserPassword($userPassword)
            ->setClientID($clientID)
            ->setAccessToken($accessToken);
    }
    /**
     * Get userID value
     * @return string|null
     */
    public function getUserID()
    {
        return $this->userID;
    }
    /**
     * Set userID value
     * @param string $userID
     * @return \StructType\Login
     */
    public function setUserID($userID = null)
    {
        // validation for constraint: string
        if (!is_null($userID) && !is_string($userID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userID, true), gettype($userID)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($userID) && mb_strlen($userID) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($userID)), __LINE__);
        }
        // validation for constraint: minLength(5)
        if (!is_null($userID) && mb_strlen($userID) < 5) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 5', mb_strlen($userID)), __LINE__);
        }
        $this->userID = $userID;
        return $this;
    }
    /**
     * Get userPassword value
     * @return string|null
     */
    public function getUserPassword()
    {
        return $this->userPassword;
    }
    /**
     * Set userPassword value
     * @param string $userPassword
     * @return \StructType\Login
     */
    public function setUserPassword($userPassword = null)
    {
        // validation for constraint: string
        if (!is_null($userPassword) && !is_string($userPassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userPassword, true), gettype($userPassword)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($userPassword) && mb_strlen($userPassword) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($userPassword)), __LINE__);
        }
        // validation for constraint: minLength(5)
        if (!is_null($userPassword) && mb_strlen($userPassword) < 5) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 5', mb_strlen($userPassword)), __LINE__);
        }
        $this->userPassword = $userPassword;
        return $this;
    }
    /**
     * Get clientID value
     * @return int|null
     */
    public function getClientID()
    {
        return $this->clientID;
    }
    /**
     * Set clientID value
     * @param int $clientID
     * @return \StructType\Login
     */
    public function setClientID($clientID = null)
    {
        // validation for constraint: int
        if (!is_null($clientID) && !(is_int($clientID) || ctype_digit($clientID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($clientID, true), gettype($clientID)), __LINE__);
        }
        $this->clientID = $clientID;
        return $this;
    }
    /**
     * Get accessToken value
     * @return string|null
     */
    public function getAccessToken()
    {
        return $this->accessToken;
    }
    /**
     * Set accessToken value
     * @param string $accessToken
     * @return \StructType\Login
     */
    public function setAccessToken($accessToken = null)
    {
        // validation for constraint: string
        if (!is_null($accessToken) && !is_string($accessToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accessToken, true), gettype($accessToken)), __LINE__);
        }
        $this->accessToken = $accessToken;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Login
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
