<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for kundenportalVerzeichnisseResponse StructType
 * Meta information extracted from the WSDL
 * - documentation: Kundenportal Verzeichnisse Response
 * @subpackage Structs
 */
class KundenportalVerzeichnisseResponse extends AbstractStructBase
{
    /**
     * The behandlerVZ
     * Meta information extracted from the WSDL
     * - documentation: Behandlerverzeichnis aller Ärzte und Spitäler
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\BehandlerVZ[]
     */
    public $behandlerVZ;
    /**
     * The behandlerArt
     * Meta information extracted from the WSDL
     * - documentation: Alle möglichen Behandlungsarten aller Ärzte und Spitäler
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\BehandlerArtKP[]
     */
    public $behandlerArt;
    /**
     * The evpServiceFault
     * Meta information extracted from the WSDL
     * - documentation: Optional Fehler
     * - minOccurs: 0
     * @var \StructType\EvpServiceFault
     */
    public $evpServiceFault;
    /**
     * Constructor method for kundenportalVerzeichnisseResponse
     * @uses KundenportalVerzeichnisseResponse::setBehandlerVZ()
     * @uses KundenportalVerzeichnisseResponse::setBehandlerArt()
     * @uses KundenportalVerzeichnisseResponse::setEvpServiceFault()
     * @param \StructType\BehandlerVZ[] $behandlerVZ
     * @param \StructType\BehandlerArtKP[] $behandlerArt
     * @param \StructType\EvpServiceFault $evpServiceFault
     */
    public function __construct(array $behandlerVZ = array(), array $behandlerArt = array(), \StructType\EvpServiceFault $evpServiceFault = null)
    {
        $this
            ->setBehandlerVZ($behandlerVZ)
            ->setBehandlerArt($behandlerArt)
            ->setEvpServiceFault($evpServiceFault);
    }
    /**
     * Get behandlerVZ value
     * @return \StructType\BehandlerVZ[]|null
     */
    public function getBehandlerVZ()
    {
        return $this->behandlerVZ;
    }
    /**
     * This method is responsible for validating the values passed to the setBehandlerVZ method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBehandlerVZ method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBehandlerVZForArrayConstraintsFromSetBehandlerVZ(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $kundenportalVerzeichnisseResponseBehandlerVZItem) {
            // validation for constraint: itemType
            if (!$kundenportalVerzeichnisseResponseBehandlerVZItem instanceof \StructType\BehandlerVZ) {
                $invalidValues[] = is_object($kundenportalVerzeichnisseResponseBehandlerVZItem) ? get_class($kundenportalVerzeichnisseResponseBehandlerVZItem) : sprintf('%s(%s)', gettype($kundenportalVerzeichnisseResponseBehandlerVZItem), var_export($kundenportalVerzeichnisseResponseBehandlerVZItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The behandlerVZ property can only contain items of type \StructType\BehandlerVZ, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set behandlerVZ value
     * @throws \InvalidArgumentException
     * @param \StructType\BehandlerVZ[] $behandlerVZ
     * @return \StructType\KundenportalVerzeichnisseResponse
     */
    public function setBehandlerVZ(array $behandlerVZ = array())
    {
        // validation for constraint: array
        if ('' !== ($behandlerVZArrayErrorMessage = self::validateBehandlerVZForArrayConstraintsFromSetBehandlerVZ($behandlerVZ))) {
            throw new \InvalidArgumentException($behandlerVZArrayErrorMessage, __LINE__);
        }
        $this->behandlerVZ = $behandlerVZ;
        return $this;
    }
    /**
     * Add item to behandlerVZ value
     * @throws \InvalidArgumentException
     * @param \StructType\BehandlerVZ $item
     * @return \StructType\KundenportalVerzeichnisseResponse
     */
    public function addToBehandlerVZ(\StructType\BehandlerVZ $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BehandlerVZ) {
            throw new \InvalidArgumentException(sprintf('The behandlerVZ property can only contain items of type \StructType\BehandlerVZ, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->behandlerVZ[] = $item;
        return $this;
    }
    /**
     * Get behandlerArt value
     * @return \StructType\BehandlerArtKP[]|null
     */
    public function getBehandlerArt()
    {
        return $this->behandlerArt;
    }
    /**
     * This method is responsible for validating the values passed to the setBehandlerArt method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBehandlerArt method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBehandlerArtForArrayConstraintsFromSetBehandlerArt(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $kundenportalVerzeichnisseResponseBehandlerArtItem) {
            // validation for constraint: itemType
            if (!$kundenportalVerzeichnisseResponseBehandlerArtItem instanceof \StructType\BehandlerArtKP) {
                $invalidValues[] = is_object($kundenportalVerzeichnisseResponseBehandlerArtItem) ? get_class($kundenportalVerzeichnisseResponseBehandlerArtItem) : sprintf('%s(%s)', gettype($kundenportalVerzeichnisseResponseBehandlerArtItem), var_export($kundenportalVerzeichnisseResponseBehandlerArtItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The behandlerArt property can only contain items of type \StructType\BehandlerArtKP, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set behandlerArt value
     * @throws \InvalidArgumentException
     * @param \StructType\BehandlerArtKP[] $behandlerArt
     * @return \StructType\KundenportalVerzeichnisseResponse
     */
    public function setBehandlerArt(array $behandlerArt = array())
    {
        // validation for constraint: array
        if ('' !== ($behandlerArtArrayErrorMessage = self::validateBehandlerArtForArrayConstraintsFromSetBehandlerArt($behandlerArt))) {
            throw new \InvalidArgumentException($behandlerArtArrayErrorMessage, __LINE__);
        }
        $this->behandlerArt = $behandlerArt;
        return $this;
    }
    /**
     * Add item to behandlerArt value
     * @throws \InvalidArgumentException
     * @param \StructType\BehandlerArtKP $item
     * @return \StructType\KundenportalVerzeichnisseResponse
     */
    public function addToBehandlerArt(\StructType\BehandlerArtKP $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BehandlerArtKP) {
            throw new \InvalidArgumentException(sprintf('The behandlerArt property can only contain items of type \StructType\BehandlerArtKP, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->behandlerArt[] = $item;
        return $this;
    }
    /**
     * Get evpServiceFault value
     * @return \StructType\EvpServiceFault|null
     */
    public function getEvpServiceFault()
    {
        return $this->evpServiceFault;
    }
    /**
     * Set evpServiceFault value
     * @param \StructType\EvpServiceFault $evpServiceFault
     * @return \StructType\KundenportalVerzeichnisseResponse
     */
    public function setEvpServiceFault(\StructType\EvpServiceFault $evpServiceFault = null)
    {
        $this->evpServiceFault = $evpServiceFault;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\KundenportalVerzeichnisseResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
