<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for kundenportalSendMessageRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Sendet eine Nachricht Request
 * @subpackage Structs
 */
class KundenportalSendMessageRequest extends AbstractStructBase
{
    /**
     * The login
     * @var \StructType\Login
     */
    public $login;
    /**
     * The empfaenger
     * Meta information extracted from the WSDL
     * - documentation: Entweder advisor aus kundenportal data oder 'Kundendienst' als string
     * @var string
     */
    public $empfaenger;
    /**
     * The header
     * @var string
     */
    public $header;
    /**
     * The content
     * @var string
     */
    public $content;
    /**
     * The telefon
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $telefon;
    /**
     * The attachment
     * Meta information extracted from the WSDL
     * - documentation: Beinhaltet den Stream des angehängten Files
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Attachment[]
     */
    public $attachment;
    /**
     * Constructor method for kundenportalSendMessageRequest
     * @uses KundenportalSendMessageRequest::setLogin()
     * @uses KundenportalSendMessageRequest::setEmpfaenger()
     * @uses KundenportalSendMessageRequest::setHeader()
     * @uses KundenportalSendMessageRequest::setContent()
     * @uses KundenportalSendMessageRequest::setTelefon()
     * @uses KundenportalSendMessageRequest::setAttachment()
     * @param \StructType\Login $login
     * @param string $empfaenger
     * @param string $header
     * @param string $content
     * @param string $telefon
     * @param \StructType\Attachment[] $attachment
     */
    public function __construct(\StructType\Login $login = null, $empfaenger = null, $header = null, $content = null, $telefon = null, array $attachment = array())
    {
        $this
            ->setLogin($login)
            ->setEmpfaenger($empfaenger)
            ->setHeader($header)
            ->setContent($content)
            ->setTelefon($telefon)
            ->setAttachment($attachment);
    }
    /**
     * Get login value
     * @return \StructType\Login|null
     */
    public function getLogin()
    {
        return $this->login;
    }
    /**
     * Set login value
     * @param \StructType\Login $login
     * @return \StructType\KundenportalSendMessageRequest
     */
    public function setLogin(\StructType\Login $login = null)
    {
        $this->login = $login;
        return $this;
    }
    /**
     * Get empfaenger value
     * @return string|null
     */
    public function getEmpfaenger()
    {
        return $this->empfaenger;
    }
    /**
     * Set empfaenger value
     * @param string $empfaenger
     * @return \StructType\KundenportalSendMessageRequest
     */
    public function setEmpfaenger($empfaenger = null)
    {
        // validation for constraint: string
        if (!is_null($empfaenger) && !is_string($empfaenger)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($empfaenger, true), gettype($empfaenger)), __LINE__);
        }
        $this->empfaenger = $empfaenger;
        return $this;
    }
    /**
     * Get header value
     * @return string|null
     */
    public function getHeader()
    {
        return $this->header;
    }
    /**
     * Set header value
     * @param string $header
     * @return \StructType\KundenportalSendMessageRequest
     */
    public function setHeader($header = null)
    {
        // validation for constraint: string
        if (!is_null($header) && !is_string($header)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($header, true), gettype($header)), __LINE__);
        }
        $this->header = $header;
        return $this;
    }
    /**
     * Get content value
     * @return string|null
     */
    public function getContent()
    {
        return $this->content;
    }
    /**
     * Set content value
     * @param string $content
     * @return \StructType\KundenportalSendMessageRequest
     */
    public function setContent($content = null)
    {
        // validation for constraint: string
        if (!is_null($content) && !is_string($content)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($content, true), gettype($content)), __LINE__);
        }
        $this->content = $content;
        return $this;
    }
    /**
     * Get telefon value
     * @return string|null
     */
    public function getTelefon()
    {
        return $this->telefon;
    }
    /**
     * Set telefon value
     * @param string $telefon
     * @return \StructType\KundenportalSendMessageRequest
     */
    public function setTelefon($telefon = null)
    {
        // validation for constraint: string
        if (!is_null($telefon) && !is_string($telefon)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($telefon, true), gettype($telefon)), __LINE__);
        }
        $this->telefon = $telefon;
        return $this;
    }
    /**
     * Get attachment value
     * @return \StructType\Attachment[]|null
     */
    public function getAttachment()
    {
        return $this->attachment;
    }
    /**
     * This method is responsible for validating the values passed to the setAttachment method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAttachment method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAttachmentForArrayConstraintsFromSetAttachment(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $kundenportalSendMessageRequestAttachmentItem) {
            // validation for constraint: itemType
            if (!$kundenportalSendMessageRequestAttachmentItem instanceof \StructType\Attachment) {
                $invalidValues[] = is_object($kundenportalSendMessageRequestAttachmentItem) ? get_class($kundenportalSendMessageRequestAttachmentItem) : sprintf('%s(%s)', gettype($kundenportalSendMessageRequestAttachmentItem), var_export($kundenportalSendMessageRequestAttachmentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The attachment property can only contain items of type \StructType\Attachment, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set attachment value
     * @throws \InvalidArgumentException
     * @param \StructType\Attachment[] $attachment
     * @return \StructType\KundenportalSendMessageRequest
     */
    public function setAttachment(array $attachment = array())
    {
        // validation for constraint: array
        if ('' !== ($attachmentArrayErrorMessage = self::validateAttachmentForArrayConstraintsFromSetAttachment($attachment))) {
            throw new \InvalidArgumentException($attachmentArrayErrorMessage, __LINE__);
        }
        $this->attachment = $attachment;
        return $this;
    }
    /**
     * Add item to attachment value
     * @throws \InvalidArgumentException
     * @param \StructType\Attachment $item
     * @return \StructType\KundenportalSendMessageRequest
     */
    public function addToAttachment(\StructType\Attachment $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Attachment) {
            throw new \InvalidArgumentException(sprintf('The attachment property can only contain items of type \StructType\Attachment, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->attachment[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\KundenportalSendMessageRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
