<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for kundenportalRegisterRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Kundenportal Register Request
 * @subpackage Structs
 */
class KundenportalRegisterRequest extends AbstractStructBase
{
    /**
     * The email
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $email;
    /**
     * The paoid
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $paoid;
    /**
     * The electronicCommunication
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $electronicCommunication;
    /**
     * The login
     * @var \StructType\Login
     */
    public $login;
    /**
     * Constructor method for kundenportalRegisterRequest
     * @uses KundenportalRegisterRequest::setEmail()
     * @uses KundenportalRegisterRequest::setPaoid()
     * @uses KundenportalRegisterRequest::setElectronicCommunication()
     * @uses KundenportalRegisterRequest::setLogin()
     * @param string $email
     * @param string $paoid
     * @param bool $electronicCommunication
     * @param \StructType\Login $login
     */
    public function __construct($email = null, $paoid = null, $electronicCommunication = null, \StructType\Login $login = null)
    {
        $this
            ->setEmail($email)
            ->setPaoid($paoid)
            ->setElectronicCommunication($electronicCommunication)
            ->setLogin($login);
    }
    /**
     * Get email value
     * @return string
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return \StructType\KundenportalRegisterRequest
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        $this->email = $email;
        return $this;
    }
    /**
     * Get paoid value
     * @return string
     */
    public function getPaoid()
    {
        return $this->paoid;
    }
    /**
     * Set paoid value
     * @param string $paoid
     * @return \StructType\KundenportalRegisterRequest
     */
    public function setPaoid($paoid = null)
    {
        // validation for constraint: string
        if (!is_null($paoid) && !is_string($paoid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paoid, true), gettype($paoid)), __LINE__);
        }
        $this->paoid = $paoid;
        return $this;
    }
    /**
     * Get electronicCommunication value
     * @return bool
     */
    public function getElectronicCommunication()
    {
        return $this->electronicCommunication;
    }
    /**
     * Set electronicCommunication value
     * @param bool $electronicCommunication
     * @return \StructType\KundenportalRegisterRequest
     */
    public function setElectronicCommunication($electronicCommunication = null)
    {
        // validation for constraint: boolean
        if (!is_null($electronicCommunication) && !is_bool($electronicCommunication)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($electronicCommunication, true), gettype($electronicCommunication)), __LINE__);
        }
        $this->electronicCommunication = $electronicCommunication;
        return $this;
    }
    /**
     * Get login value
     * @return \StructType\Login|null
     */
    public function getLogin()
    {
        return $this->login;
    }
    /**
     * Set login value
     * @param \StructType\Login $login
     * @return \StructType\KundenportalRegisterRequest
     */
    public function setLogin(\StructType\Login $login = null)
    {
        $this->login = $login;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\KundenportalRegisterRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
