<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for kundenportalNewsletterEmailsResponse StructType
 * Meta information extracted from the WSDL
 * - documentation: Kundenportal Newsletter Response
 * @subpackage Structs
 */
class KundenportalNewsletterEmailsResponse extends AbstractStructBase
{
    /**
     * The email
     * Meta information extracted from the WSDL
     * - documentation: Newsletter Kunde
     * - maxOccurs: unbounded
     * @var \StructType\KundenportalNewsletterEmail[]
     */
    public $email;
    /**
     * The evpServiceFault
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\EvpServiceFault
     */
    public $evpServiceFault;
    /**
     * Constructor method for kundenportalNewsletterEmailsResponse
     * @uses KundenportalNewsletterEmailsResponse::setEmail()
     * @uses KundenportalNewsletterEmailsResponse::setEvpServiceFault()
     * @param \StructType\KundenportalNewsletterEmail[] $email
     * @param \StructType\EvpServiceFault $evpServiceFault
     */
    public function __construct(array $email = array(), \StructType\EvpServiceFault $evpServiceFault = null)
    {
        $this
            ->setEmail($email)
            ->setEvpServiceFault($evpServiceFault);
    }
    /**
     * Get email value
     * @return \StructType\KundenportalNewsletterEmail[]|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * This method is responsible for validating the values passed to the setEmail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEmail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEmailForArrayConstraintsFromSetEmail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $kundenportalNewsletterEmailsResponseEmailItem) {
            // validation for constraint: itemType
            if (!$kundenportalNewsletterEmailsResponseEmailItem instanceof \StructType\KundenportalNewsletterEmail) {
                $invalidValues[] = is_object($kundenportalNewsletterEmailsResponseEmailItem) ? get_class($kundenportalNewsletterEmailsResponseEmailItem) : sprintf('%s(%s)', gettype($kundenportalNewsletterEmailsResponseEmailItem), var_export($kundenportalNewsletterEmailsResponseEmailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The email property can only contain items of type \StructType\KundenportalNewsletterEmail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set email value
     * @throws \InvalidArgumentException
     * @param \StructType\KundenportalNewsletterEmail[] $email
     * @return \StructType\KundenportalNewsletterEmailsResponse
     */
    public function setEmail(array $email = array())
    {
        // validation for constraint: array
        if ('' !== ($emailArrayErrorMessage = self::validateEmailForArrayConstraintsFromSetEmail($email))) {
            throw new \InvalidArgumentException($emailArrayErrorMessage, __LINE__);
        }
        $this->email = $email;
        return $this;
    }
    /**
     * Add item to email value
     * @throws \InvalidArgumentException
     * @param \StructType\KundenportalNewsletterEmail $item
     * @return \StructType\KundenportalNewsletterEmailsResponse
     */
    public function addToEmail(\StructType\KundenportalNewsletterEmail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\KundenportalNewsletterEmail) {
            throw new \InvalidArgumentException(sprintf('The email property can only contain items of type \StructType\KundenportalNewsletterEmail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->email[] = $item;
        return $this;
    }
    /**
     * Get evpServiceFault value
     * @return \StructType\EvpServiceFault|null
     */
    public function getEvpServiceFault()
    {
        return $this->evpServiceFault;
    }
    /**
     * Set evpServiceFault value
     * @param \StructType\EvpServiceFault $evpServiceFault
     * @return \StructType\KundenportalNewsletterEmailsResponse
     */
    public function setEvpServiceFault(\StructType\EvpServiceFault $evpServiceFault = null)
    {
        $this->evpServiceFault = $evpServiceFault;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\KundenportalNewsletterEmailsResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
