<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KundenportalNewsletterEmail StructType
 * Meta information extracted from the WSDL
 * - documentation: KundenportalNewsletterEmail
 * @subpackage Structs
 */
class KundenportalNewsletterEmail extends AbstractStructBase
{
    /**
     * The email
     * @var mixed
     */
    public $email;
    /**
     * The firstName
     * Meta information extracted from the WSDL
     * - documentation: Vorname für natürliche Personen
     * - base: xsd:string
     * - maxLength: 50
     * - minOccurs: 0
     * @var string
     */
    public $firstName;
    /**
     * The sureName
     * Meta information extracted from the WSDL
     * - documentation: Familien-, Gruppen-, bzw. Firmenname
     * - base: xsd:string
     * - maxLength: 50
     * @var string
     */
    public $sureName;
    /**
     * The geschlecht
     * @var mixed
     */
    public $geschlecht;
    /**
     * Constructor method for KundenportalNewsletterEmail
     * @uses KundenportalNewsletterEmail::setEmail()
     * @uses KundenportalNewsletterEmail::setFirstName()
     * @uses KundenportalNewsletterEmail::setSureName()
     * @uses KundenportalNewsletterEmail::setGeschlecht()
     * @param mixed $email
     * @param string $firstName
     * @param string $sureName
     * @param mixed $geschlecht
     */
    public function __construct($email = null, $firstName = null, $sureName = null, $geschlecht = null)
    {
        $this
            ->setEmail($email)
            ->setFirstName($firstName)
            ->setSureName($sureName)
            ->setGeschlecht($geschlecht);
    }
    /**
     * Get email value
     * @return mixed|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param mixed $email
     * @return \StructType\KundenportalNewsletterEmail
     */
    public function setEmail($email = null)
    {
        $this->email = $email;
        return $this;
    }
    /**
     * Get firstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->firstName;
    }
    /**
     * Set firstName value
     * @param string $firstName
     * @return \StructType\KundenportalNewsletterEmail
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstName, true), gettype($firstName)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($firstName) && mb_strlen($firstName) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($firstName)), __LINE__);
        }
        $this->firstName = $firstName;
        return $this;
    }
    /**
     * Get sureName value
     * @return string|null
     */
    public function getSureName()
    {
        return $this->sureName;
    }
    /**
     * Set sureName value
     * @param string $sureName
     * @return \StructType\KundenportalNewsletterEmail
     */
    public function setSureName($sureName = null)
    {
        // validation for constraint: string
        if (!is_null($sureName) && !is_string($sureName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sureName, true), gettype($sureName)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($sureName) && mb_strlen($sureName) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($sureName)), __LINE__);
        }
        $this->sureName = $sureName;
        return $this;
    }
    /**
     * Get geschlecht value
     * @return mixed|null
     */
    public function getGeschlecht()
    {
        return $this->geschlecht;
    }
    /**
     * Set geschlecht value
     * @param mixed $geschlecht
     * @return \StructType\KundenportalNewsletterEmail
     */
    public function setGeschlecht($geschlecht = null)
    {
        $this->geschlecht = $geschlecht;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\KundenportalNewsletterEmail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
